(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    135294,       3883]*)
(*NotebookOutlinePosition[    135994,       3907]*)
(*  CellTagsIndexPosition[    135950,       3903]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
Pr\[AAcute]ctica 3
Ecuaciones diferenciales\
\>", "Title"],

Cell[CellGroupData[{

Cell["Ejercicio 1 (oscilaciones libres con amortiguamiento)", "Exercise"],

Cell[TextData[{
  "La ED  ",
  Cell[BoxData[
      \(TraditionalForm\`y'' \((t)\) + c\ y' \((t)\) + d\ \(y(t)\) = 
        f(t)\)]],
  "  donde ",
  Cell[BoxData[
      \(TraditionalForm\`c \[GreaterEqual] 0, \ d \[GreaterEqual] 0\)]],
  " recibe el nombre de ",
  StyleBox["oscilador arm\[OAcute]nico",
    FontSlant->"Italic"],
  ". Esta ED podemos interpretarla como modelo del movimiento de un sistema \
mec\[AAcute]nico formado por un cuerpo sujeto al extremo de un muelle o de la \
corriente en un circuito el\[EAcute]ctrico RLC. Las respectivas EDs son:\n\
Sistema mec\[AAcute]nico:  ",
  Cell[BoxData[
      \(TraditionalForm\`m\ y'' \((t)\) + \[Mu]\ y' \((t)\) + k\ \(y(t)\) = 
        f(t)\)]],
  ". \nInterpretaci\[OAcute]n: ",
  Cell[BoxData[
      \(TraditionalForm\`y(t)\)]],
  " desplazamiento del cuerpo medido desde el cdg del cuerpo en la posici\
\[OAcute]n de equilibrio, ",
  Cell[BoxData[
      \(TraditionalForm\`f(t)\)]],
  " fuerza externa aplicada al cuerpo, ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " masa del cuerpo, ",
  Cell[BoxData[
      \(TraditionalForm\`\[Mu]\)]],
  " coeficiente de amortiguamiento, ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " constante de recuperaci\[OAcute]n del muelle.\nCircuito RLC: ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{\(L\ q'' \((t)\)\), "+", 
            RowBox[{"R", " ", 
              FormBox[\(q' \((t)\) + 1\/C\),
                "TraditionalForm"], \(q(t)\)}]}], "=", \(f(t)\)}], 
        TraditionalForm]]],
  ".\nInterpretaci\[OAcute]n: ",
  Cell[BoxData[
      \(TraditionalForm\`q(t)\)]],
  " carga que circula por el circuito, ",
  Cell[BoxData[
      \(TraditionalForm\`f(t)\)]],
  " fuerza electromotriz aplicada, ",
  Cell[BoxData[
      \(TraditionalForm\`L\)]],
  " autoinductancia, ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  " resistencia, ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  " capacidad.\nAmbas EDs pueden escribirse en la forma ",
  Cell[BoxData[
      \(TraditionalForm\`y'' \((t)\) + c\ y' \((t)\) + d\ \(y(t)\) = 
        f(t)\)]],
  " donde, en el primer caso, ",
  Cell[BoxData[
      \(TraditionalForm\`c = \[Mu]\/m, \ d = k\/m\)]],
  ", y en el segundo ",
  Cell[BoxData[
      \(TraditionalForm\`c = R\/L, \ d = \ 1\/\(C\ L\)\)]],
  ". Es por ello que el estudio de esta ecuaci\[OAcute]n es muy interesante. \
\nEn la ED del oscilador arm\[OAcute]nico ",
  Cell[BoxData[
      \(TraditionalForm\`y'' \((t)\) + c\ y' \((t)\) + d\ \(y(t)\) = 
        f(t)\)]],
  " el coeficiente ",
  Cell[BoxData[
      \(TraditionalForm\`c \[GreaterEqual] 0\)]],
  " se interpreta como un amortiguamiento. Cuando ",
  Cell[BoxData[
      \(TraditionalForm\`c = 0\)]],
  ", se dice que no hay amortiguamiento. Cuando la fuerza ",
  Cell[BoxData[
      \(TraditionalForm\`f(t) = 0\)]],
  " se dice que se trata de oscilaciones libres."
}], "ExerciseText"],

Cell[TextData[{
  "La soluci\[OAcute]n de la ED ",
  Cell[BoxData[
      \(TraditionalForm\`y'' \((t)\) + c\ y' \((t)\) + d\ \(y(t)\) = 0\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`c \[GreaterEqual] \ 0, \ d > 0\)]],
  " con condiciones iniciales ",
  Cell[BoxData[
      \(TraditionalForm\`y[0] = a, \ \(y'\)[0] = b\)]],
  " est\[AAcute] estudiada con detalle en los fundamentos de esta \
pr\[AAcute]ctica."
}], "ExerciseText"],

Cell[TextData[{
  "a) Calcula con DSolve[ ] la soluci\[OAcute]n de la ED ",
  Cell[BoxData[
      \(TraditionalForm\`y'' \((t)\) + \ c\ y' \((t)\) + \ y(t) = 0, \ 
      c > 0\)]],
  ", con condiciones iniciales ",
  Cell[BoxData[
      \(TraditionalForm\`y[0] = 1, \ \(y'\)[0] = 1\)]],
  ". \nb) Suponiendo que ",
  Cell[BoxData[
      \(TraditionalForm\`c\^2 < 4\)]],
  ", comprueba con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que la soluci\[OAcute]n es de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(h(
          t)\)\(\ \)\(Sin[\[Omega]\ t + \[CurlyPhi]]\)\(\ \)\)\)]],
  "donde ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega], \ \[CurlyPhi]\)]],
  " son independientes de ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`h(t) = C\ e\^\(\(-\[Mu]\)\ t\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`C, \ \[Mu] > 0\)]],
  " no dependen de ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " (movimiento oscilatorio amortiguado, ",
  Cell[BoxData[
      \(TraditionalForm\`h(t)\)]],
  " es su amplitud, ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\)]],
  " su frecuencia en radianes por segundo). Representa gr\[AAcute]ficamente \
esta soluci\[OAcute]n en el intervalo [0,20]  junto con las funciones ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(h(t)\)\(\ \)\)\)]],
  "y ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\(h(t)\)\)\)]],
  " variando ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " de 0 a 1.6 a intervalos de 0.1. \[DownQuestion]C\[OAcute]mo afecta el \
aumento de ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " a la soluci\[OAcute]n? \[DownQuestion]Qu\[EAcute] ocurre para valores muy \
grandes de ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  ", por ejemplo ",
  Cell[BoxData[
      \(TraditionalForm\`c = 5\)]],
  "?"
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2 (oscilaciones forzadas con amortiguamiento)", "Exercise"],

Cell[TextData[{
  "La ED ",
  Cell[BoxData[
      \(TraditionalForm\`y'' \((t)\) + c\ y' \((t)\) + d\ \(y(t)\) = 
        f(t)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`c > 0, \ d > 0\)]],
  ", corresponde a oscilaciones forzadas con amortiguamiento.  Para obtener \
la soluci\[OAcute]n de dicha ED con condiciones iniciales ",
  Cell[BoxData[
      \(TraditionalForm\`y[0] = a, \ \(y'\)[0] = b\)]],
  ", es costumbre proceder como sigue.\n1) Se calcula la soluci\[OAcute]n que \
corresponde a la ED no forzada, ",
  Cell[BoxData[
      \(TraditionalForm\`y'' \((t)\) + c\ y' \((t)\) + d\ \(y(t)\) = 0\)]],
  " con condiciones iniciales ",
  Cell[BoxData[
      \(TraditionalForm\`y[0] = a, \ \(y'\)[0] = b\)]],
  ". Esta soluci\[OAcute]n se llama ",
  StyleBox["soluci\[OAcute]n transitoria",
    FontSlant->"Italic"],
  " y depender\[AAcute] de los coeficientes ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`d\)]],
  ", las condiciones inciales ",
  Cell[BoxData[
      \(TraditionalForm\`a, b\)]],
  " y la variable ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ".\n2) Se calcula la soluci\[OAcute]n de la ED forzada ",
  Cell[BoxData[
      \(TraditionalForm\`y'' \((t)\) + c\ y' \((t)\) + d\ \(y(t)\) = 
        f(t)\)]],
  " con condiciones iniciales ",
  Cell[BoxData[
      \(TraditionalForm\`y[0] = \(\(y'\)[0] = 0\)\)]],
  ". Esta soluci\[OAcute]n se conoce como ",
  StyleBox["soluci\[OAcute]n de estado estacionario",
    FontSlant->"Italic"],
  " y depender\[AAcute] de los coeficientes ",
  Cell[BoxData[
      \(TraditionalForm\`c > 0\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`d > 0\)]],
  ", de la variable ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " y de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ". \nLa suma de la soluci\[OAcute]n transitoria y la soluci\[OAcute]n de \
estado estacionario es la soluci\[OAcute]n buscada.\na) Consideremos la ED ",
  Cell[BoxData[
      \(TraditionalForm\`y'' \((t)\) + c\ y' \((t)\) + 
          d\ \(y(t)\) = \[Lambda]\ Cos[\[Omega]\ t]\)]],
  " donde donde ",
  Cell[BoxData[
      \(TraditionalForm\`c > 0, \ d > 0\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda] \[GreaterEqual] \ 0, \ \[Omega] > 0\)]],
  " son constantes, con condiciones iniciales ",
  Cell[BoxData[
      \(TraditionalForm\`y[0] = a, \ \(y'\)[0] = b\)]],
  ". Calcula con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " la soluci\[OAcute]n transitoria, ",
  Cell[BoxData[
      \(TraditionalForm\`soltransitoria[c, d, a, b, t]\)]],
  ",  y la soluci\[OAcute]n de estado estacionario, ",
  Cell[BoxData[
      \(TraditionalForm\`solestacionario[c, d, \[Lambda], \[Omega]]\)]],
  ". \nb) Suponiendo que ",
  Cell[BoxData[
      \(TraditionalForm\`c\^2 - 4  d < 0\)]],
  ", comprueba con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que la soluci\[OAcute]n transitoria es de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`C\ \(e\^\(\(-\[Mu]\)\ t\)\) 
        Sin[\[Nu]\ t + \[Theta]]\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`C, \[Nu], \ \[Theta], \(\(\[Mu]\)\(>\)\(0\)\(\ \
\)\)\)]],
  "no dependen de ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " y la soluci\[OAcute]n de estado estacionario es de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`A\ Sin[\[Omega]\ t\  + \ \[Beta]]\  + \(\(K\)\(\ \
\)\(e\^\(\(-\[Mu]\)\ t\)\) \(Sin[\[Nu]\ t + \[CurlyPhi]]\)\(\ \)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`A, \ \[Beta], \ K, \ \[CurlyPhi]\)]],
  " no dependen de ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ".\nRepresenta gr\[AAcute]ficamente las soluciones obtenidas junto con su \
suma para los valores ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(a = \(b = \(c = \(d = 1\)\)\), \[Lambda] = 
        100\)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega] = 7\)]],
  ". Elige opciones de color y grosor de l\[IAcute]nea apropiadas."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Ejercicio 3 (respuesta impulsiva, convoluci\[OAcute]n, funci\[OAcute]n delta \
de Dirac)\
\>", "Exercise"],

Cell[TextData[{
  "Consideremos un sistema LTI cuya salida (output) ",
  Cell[BoxData[
      \(TraditionalForm\`y(t)\)]],
  " y entrada (input) ",
  Cell[BoxData[
      \(TraditionalForm\`f(t)\)]],
  " est\[AAcute]n relacionadas por la ED ",
  Cell[BoxData[
      \(TraditionalForm\`y'' \((t)\) + c\ y' \((t)\) + d\ \(y(t)\) = 
        f(t)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`c > 0, \ d > 0\)]],
  ". Se llama ",
  StyleBox["respuesta impulsiva",
    FontSlant->"Italic"],
  " de dicho sistema a la soluci\[OAcute]n de la ED ",
  Cell[BoxData[
      \(TraditionalForm\`y'' \((t)\) + c\ y' \((t)\) + d\ \(y(t)\) = 0\)]],
  " con las condiciones ",
  Cell[BoxData[
      \(TraditionalForm\`y[0] = 0, \ \(y'\)[0] = 1\)]],
  ". La respuesta impulsiva depende de los coeficientes ",
  Cell[BoxData[
      \(TraditionalForm\`c > 0\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`d > 0\)]],
  " y de la variable ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ". Se demuestra que la soluci\[OAcute]n de estado etacionario viene dada \
por la integral de convoluci\[OAcute]n  ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_0\%t\), " ", 
          RowBox[{
            FormBox[\(impulsiva[c, d, t - x]\),
              "TraditionalForm"], \(f[x]\), \(\[DifferentialD]x\)}]}], 
        TraditionalForm]]],
  ". Vamos a comprobar esto con ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "en algunos casos particulares.\na) Calcula la respuesta impulsiva, ",
  Cell[BoxData[
      \(TraditionalForm\`impulsiva[c, d, t]\)]],
  ".\nb) Supuesto que ",
  Cell[BoxData[
      \(TraditionalForm\`f(t) = \[Lambda]\ Cos[\[Omega]\ t]\)]],
  ", comprueba que la respuesta de estado estacionario es igual a  ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_0\%t\), " ", 
          RowBox[{
            FormBox[\(impulsiva[c, d, t - x]\),
              "TraditionalForm"], "\[Lambda]", 
            " ", \(Cos[\[Omega]\ x]\), \(\[DifferentialD]x\)}]}], 
        TraditionalForm]]],
  ".\nc) b) Supuesto que ",
  Cell[BoxData[
      \(TraditionalForm\`f(t) = Exp[\[Omega]\ t]\)]],
  ", comprueba que la respuesta de estado estacionario es igual a  ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_0\%t\), " ", 
          RowBox[{
            FormBox[\(impulsiva[c, d, t - x]\),
              
              "TraditionalForm"], \(Exp[\[Omega]\ x]\), \
\(\[DifferentialD]x\)}]}], TraditionalForm]]],
  ".\nd) Simplifica la respuesta impulsiva para el caso de ra\[IAcute]ces \
imaginarias."
}], "ExerciseText"],

Cell[TextData[{
  "e) Hay una forma de interpretar la respuesta impulsiva que es muy \
intuitiva desde un punto de vista f\[IAcute]sico: la respuesta impulsiva es \
la respuesta del sistema a una fuerza externa s\[UAcute]bita e instant\
\[AAcute]nea. Matem\[AAcute]ticamente una fuerza s\[UAcute]bita e instant\
\[AAcute]nea puede ",
  StyleBox["aproximarse",
    FontSlant->"Italic"],
  " por un impulso de duraci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] > 0\)]],
  " e intensidad ",
  Cell[BoxData[
      \(TraditionalForm\`1/\[Epsilon]\)]],
  ". La siguiente funci\[OAcute]n, ",
  Cell[BoxData[
      \(TraditionalForm\`impulso[t, \[Epsilon]]\)]],
  ",  permite visualizar este impulso (consulta, si es preciso, en la ayuda \
del programa la funci\[OAcute]n UnitStep[ ])."
}], "ExerciseText"],

Cell[BoxData[{
    \(\(impulso[
          t_, \[Epsilon]_] = \((UnitStep[t] - 
              UnitStep[
                t - \[Epsilon]])\)/\[Epsilon];\)\[IndentingNewLine] (*\ 
      esta\ funci\[OAcute]n\ toma\ los\ siguientes\ valores\ *) \), "\
\[IndentingNewLine]", 
    \({Simplify[impulso[t, \[Epsilon]], 0 \[LessEqual] t < \ \[Epsilon]], 
      Simplify[impulso[t, \[Epsilon]], t \[GreaterEqual] \[Epsilon] > 0], 
      Simplify[impulso[t, \[Epsilon]], 
        t < 0 && \[Epsilon] > 0]}\), "\[IndentingNewLine]", 
    \(\(\(Plot[impulso[t, 1/1000], {t, \(- .02\),  .02}]\)\(;\)\( (*\ 
      observa\ la\ escala\ de\ los\ ejes\ *) \)\)\)}], "Input"],

Cell[TextData[{
  "e1) Calcula, con DSolve[ ], la respuesta impulsiva de la ED ",
  Cell[BoxData[
      \(TraditionalForm\`\(y''\)[t] + \(y'\)[t] + \ y[t] = 0\)]],
  ", es decir, la soluci\[OAcute]n de dicha ED que satisface las condiciones \
iniciales ",
  Cell[BoxData[
      \(TraditionalForm\`y(0) = 0, \ y' \((0)\) = 1\)]],
  ". Llama a esta funci\[OAcute]n \"respuestaimpulsiva[t]\".\ne2) Calcula, \
usando NDSolve[ ], la soluci\[OAcute]n de estado estacionario de la ED ",
  Cell[BoxData[
      \(TraditionalForm\`\(y''\)[t] + \ \(y'\)[t] + \ \ y[t] = 
        impulso[t, \[Epsilon]]\)]],
  " es decir, la soluci\[OAcute]n de dicha ED que satisface las condiciones \
iniciales ",
  Cell[BoxData[
      \(TraditionalForm\`y(0) = 0, \ y' \((0)\) = 0\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " en el intervalo [0,10]. LLama a esta soluci\[OAcute]n respuestaimpulso[\
\[Epsilon]].\nSugerencia: Debes usar asignaci\[OAcute]n diferida y una \
sustituci\[OAcute]n de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(y\)\(/.\)\)\)]],
  " para que tenga sentido la expresi\[OAcute]n \
respuestaimpulso[\[Epsilon]][t] y pueda ser evaluada para valores \
num\[EAcute]ricos de \[Epsilon] y ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ".\ne3) Representa gr\[AAcute]ficamente, en la misma gr\[AAcute]fica, las \
funciones respuestaimpulsiva[t] y respuestaimpulso[1-\[Delta]][t] donde \
\[Delta] toma valores desde .11 hasta .99 con incrementos de .11. Comenta lo \
que ves.\ne4) Calcula, con DSolve[ ], soluci\[OAcute]n de estado estacionario \
de la ED ",
  Cell[BoxData[
      \(TraditionalForm\`\(y''\)[t] + \(y'\)[t] + \ y[t] = 
        UnitStep[t]/\[Epsilon]\)]],
  ". Llama a esta funci\[OAcute]n \"sol1[t,\[Epsilon]]\".\ne5) Calcula, con \
DSolve[ ], la soluci\[OAcute]n de estado estacionario de la ED ",
  Cell[BoxData[
      \(TraditionalForm\`\(y''\)[t] + \(y'\)[t] + \ y[t] = 
        UnitStep[t - \[Epsilon]]/\[Epsilon]\)]],
  ". Llama a esta funci\[OAcute]n \"sol2[t,\[Epsilon]]\".\nLa funci\[OAcute]n \
",
  Cell[BoxData[
      \(TraditionalForm\`sol1[t, \[Epsilon]] - sol2[t, \[Epsilon]]\)]],
  " es la soluci\[OAcute]n de estado estacionario de la ED ",
  Cell[BoxData[
      \(TraditionalForm\`\(y''\)[t] + \(y'\)[t] + \ 
          y[t] = \(\(impulso[t, \[Epsilon]]\)\(.\)\)\)]],
  "\ne6) Comprueba con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(Lim\_\(\[Epsilon] \[Rule] 0\)\)(
          sol1[t, \[Epsilon]] - sol2[t, \[Epsilon]])\)\(\ \)\(=\)\)\)]],
  "respuestaimpulsiva[t]UnitStep[t]."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sobre la \"funci\[OAcute]n delta de Dirac\"", "Subsubsection"],

Cell[TextData[{
  "A la vista de estos resultados, parece claro que la respuesta impulsiva \
del sistema es el l\[IAcute]mite para ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] \[Rule] 0\)]],
  " de la respuesta estacionaria del sistema al \"impulso de duraci\[OAcute]n \
\[Epsilon]\", impulso[t,\[Epsilon]]. Llamemos, ",
  Cell[BoxData[
      \(TraditionalForm\`\(y\_imp\)(t)\)]],
  " a la primera e ",
  Cell[BoxData[
      \(TraditionalForm\`\(y\_imp\)(t, \[Epsilon])\)]],
  " a la segunda. Seg\[UAcute]n acabamos de ver, ",
  Cell[BoxData[
      \(TraditionalForm\`\(y\_imp\)(t) = 
        lim\_\(\[Epsilon] \[Rule] 0\)\(y\_imp\)(t, \[Epsilon])\)]],
  ". Por otra parte, se verificar\[AAcute] que"
}], "ExerciseText"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`y\_imp'' \((t, \[Epsilon])\) + 
        y\_imp' \((t, \[Epsilon])\) + \(y\_imp\)(t, \[Epsilon]) = 
      impulso(t, \[Epsilon]), \ \(y\_imp\)(0, \[Epsilon]) = 0, \ 
    y\_imp' \((0, \[Epsilon])\) = 0\)]]], "ExerciseText",
  TextAlignment->Center],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`y\_imp'' \((t)\) + y\_imp' \((t)\) + \(y\_imp\)(t) = 
      0, \(y\_imp\)(0) = 
      0, \ \(\(y\_imp' \((0)\)\)\(=\)\(1\)\(\ \)\)\)]]], "ExerciseText",
  TextAlignment->Center],

Cell[TextData[{
  "\[DownQuestion]No es absolutamente tentador tomar l\[IAcute]mites en la \
primera de estas EDs para ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] \[Rule] 0\)]],
  "? Veamos. Aqu\[IAcute] hay algunas dificultades matem\[AAcute]ticas. La \
primera es que la operaci\[OAcute]n de derivar rara vez conmuta con la de \
paso al l\[IAcute]mite. En general, no es lo mismo derivar primero y tomar l\
\[IAcute]mite despu\[EAcute]s que invertir el proceso. Pero hay otra \
dificultad que salta a la vista: la condici\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(y\_imp' \((0, \[Epsilon])\) = 0\)\)\)]],
  " dif\[IAcute]cilmente se puede convertir en el l\[IAcute]mite en la \
condici\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(y\_imp' \((0)\)\)\(=\)\(1.\)\(\ \)\)\)]],
  "Adem\[AAcute]s, se tiene que ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", Cell[TextData[Cell[BoxData[
              \(TraditionalForm\`lim\_\(\[Epsilon] \[Rule] 0\)impulso(
                    t, \[Epsilon]) = 0\)]]]]}], TraditionalForm]]],
  ", para todo  ",
  Cell[BoxData[
      \(TraditionalForm\`t \[NotEqual] 0\)]],
  " mientras que ",
  Cell[BoxData[
      \(TraditionalForm\`lim\_\(\[Epsilon] \[Rule] 0\)impulso(
            0, \[Epsilon]) = \(+\[Infinity]\)\)]],
  ". Pero dejemos hablar a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "ExerciseText"],

Cell[BoxData[{
    \(Limit[impulso[t, \[Epsilon]], \[Epsilon] \[Rule] 0, 
      Assumptions \[Rule] t \[NotEqual] 0]\), "\[IndentingNewLine]", 
    \(Limit[impulso[0, \[Epsilon]], \[Epsilon] \[Rule] 0]\)}], "Input"],

Cell["\<\
Por otra parte, observa que lo que estamos calculando es una derivada.\
\>", "ExerciseText"],

Cell[BoxData[
    \(impulso[t, \[Epsilon]] /. \[Epsilon] \[Rule] \(-\[Epsilon]\) // 
      Simplify\)], "Input"],

Cell[TextData[{
  "Este l\[IAcute]mite es, por definici\[OAcute]n, la derivada de la funci\
\[OAcute]n UnitStep[ ] en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ". Esa derivada no tiene ning\[UAcute]n problema en puntos ",
  Cell[BoxData[
      \(TraditionalForm\`t \[NotEqual] 0\)]],
  " pero para ",
  Cell[BoxData[
      \(TraditionalForm\`t = 0\)]],
  " no existe (o vale ",
  Cell[BoxData[
      \(TraditionalForm\`\(+\[Infinity]\)\)]],
  "). Veamos lo que sabe ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " de la derivada de la funci\[OAcute]n UnitStep[ ]."
}], "ExerciseText"],

Cell[BoxData[
    \(D[UnitStep[t], t]\)], "Input"],

Cell["\<\
\[DownExclamation]Acaba de aparecer la famos\[IAcute]sima \"delta de \
Dirac\"!. Veamos algo sobre ella.\
\>", "ExerciseText"],

Cell[BoxData[{
    \(DiracDelta[34]\), "\[IndentingNewLine]", 
    \(DiracDelta[\(-2.89\)]\), "\[IndentingNewLine]", 
    \(DiracDelta[0]\), "\[IndentingNewLine]", 
    \(\(Plot[DiracDelta[t], {t, \(-1000\), 1000}];\)\)}], "Input"],

Cell["\<\
Pues, no parece gran cosa esta funci\[OAcute]n... En cero no est\[AAcute] \
definida y en los dem\[AAcute]s puntos se anula \[DownQuestion]Qu\[EAcute] \
puede hacerse con algo as\[IAcute]? Pese a todo, la intuici\[OAcute]n f\
\[IAcute]sica nos dice que si en la ED\
\>", "ExerciseText"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`y\_imp'' \((t, \[Epsilon])\) + 
        y\_imp' \((t, \[Epsilon])\) + \(y\_imp\)(t, \[Epsilon]) = 
      impulso(t, \[Epsilon]), \ \(y\_imp\)(0, \[Epsilon]) = 0, \ 
    y\_imp' \((0, \[Epsilon])\) = 0\)]]], "ExerciseText",
  TextAlignment->Center],

Cell[TextData[{
  "tomamos l\[IAcute]mites para ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] \[Rule] 0\)]],
  " y escribimos la ED"
}], "ExerciseText"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`y'' \((t)\) + y' \((t)\) + y(t) = DiracDelta(t), \ 
    y(0) = 0, \ y' \((0)\) = 1\)]]], "ExerciseText",
  TextAlignment->Center],

Cell[TextData[{
  "Entonces la soluci\[OAcute]n de esta ED ",
  StyleBox["deber\[IAcute]a ser la respuesta impulsiva",
    FontSlant->"Italic"],
  ". \[DownQuestion]Se producir\[AAcute] el milagro? Dejemos que nos lo diga \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "ExerciseText"],

Cell[BoxData[
    \(y[t] /. \(DSolve[{\(y''\)[t] + \(y'\)[t] + y[t] \[Equal] DiracDelta[t], 
            y[0] \[Equal] 0, \(y'\)[0] \[Equal] 1}, y, 
          t]\)[\([1]\)]\)], "Input"],

Cell[TextData[{
  "Pues \[DownExclamation]SI! hemos recuperado la respuesta impulsiva. Para \
ser exactos, la soluci\[OAcute]n obtenida es igual a la respuesta impulsiva \
para ",
  Cell[BoxData[
      \(TraditionalForm\`t > 0\)]],
  " y se anula para ",
  Cell[BoxData[
      \(TraditionalForm\`t \[LessEqual] 0\)]],
  ". Esto no es magia matem\[AAcute]tica. La funci\[OAcute]n DiracDelta[ ] no \
es tratada por ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " como una funci\[OAcute]n usual porque no lo es. Los fundamentos matem\
\[AAcute]ticos que justifican los c\[AAcute]lculos usuales con la funci\
\[OAcute]n DiracDelta[ ] y otras de su estilo no son en absoluto elementales \
y constituyen una de las teor\[IAcute]as m\[AAcute]s celebradas de las Matem\
\[AAcute]ticas del siglo XX: la llamada ",
  StyleBox["teor\[IAcute]a de distribuciones o funciones generalizadas.",
    FontSlant->"Italic"],
  " Para terminar, veamos lo que pasa al calcular la soluci\[OAcute]n de \
estado estacionario para la funci\[OAcute]n DiracDelta[ ]."
}], "ExerciseText"],

Cell[BoxData[
    \(y[t] /. \(DSolve[{\(y''\)[t] + \(y'\)[t] + y[t] \[Equal] DiracDelta[t], 
            y[0] \[Equal] 0, \(y'\)[0] \[Equal] 0}, y, 
          t]\)[\([1]\)]\)], "Input"],

Cell[TextData[{
  "Hemos obtenido la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(-respuestaimpulsiva[t]\)\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`t < 0\)]],
  " e igual a 0 para ",
  Cell[BoxData[
      \(TraditionalForm\`t \[GreaterEqual] 0. \)]]
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 4 (resonancia)", "Exercise"],

Cell[TextData[{
  "Cuando a un sistema oscilatorio (muelle o circuito el\[EAcute]ctrico) \
aplicamos una fuerza exterior cuya frecuencia es igual a la ",
  StyleBox["frecuencia natural",
    FontSlant->"Italic"],
  " del sistema (la frecuencia del sistema cuando oscila libremente sin \
amortiguamiento), se produce un fen\[OAcute]meno conocido como ",
  StyleBox["resonancia",
    FontSlant->"Italic"],
  " cuyo efecto es que la amplitud de las oscilaciones crece indefinidamente. \
Puedes entender f\[AAcute]cilmente este fen\[OAcute]meno suponiendo que \
quieres desplazar al m\[AAcute]ximo un cuerpo pesado que puede moverse \
oscilando en torno a una posici\[OAcute]n de equilibrio. Por ejemplo, quieres \
mover una gran piedra redonda situada en el fondo de un agujero semicircular. \
En esta circunstancia, lo mejor es empujar la piedra en el sentido de su \
movimiento: hacia arriba cuando la piedra sube y hacia abajo cuando la piedra \
cae. Lo que estamos haciendo es aplicar una fuerza peri\[OAcute]dica cuyo per\
\[IAcute]odo ajustamos para que la amplitud del movimiento vaya aumentando \
con cada empujoncito. Esto es lo que sucede en los fen\[OAcute]menos de \
resonancia. \nUn sintonizador de una radio modifica la autoinducci\[OAcute]n \
de un circuito el\[EAcute]ctrico de forma que la frecuencia de resonancia del \
mismo var\[IAcute]a de forma continua;  as\[IAcute] en cada momento queda \
seleccionada la se\[NTilde]al de la emisora que emite en dicha frecuencia, \
dicha se\[NTilde]al es amplificada y puede o\[IAcute]rse con nitidez (siempre \
que no haya otras emisoras que emitan en una frecuencia muy parecida).\nLos \
edificios, puentes, motores,... pueden oscilar y tienen su propia frecuencia \
de resonancia que debe ser evitada para prevenir posibles accidentes. "
}], "ExerciseText"],

Cell[TextData[{
  "a) Calcula la soluci\[OAcute]n de la ED ",
  Cell[BoxData[
      \(TraditionalForm\`y'' \((t)\) + d\ \(y(t)\) = 0\)]],
  " con condiciones iniciales ",
  Cell[BoxData[
      \(TraditionalForm\`y(0) = a, y' \((0)\) = b\)]],
  ". Representa dicha soluci\[OAcute]n por ",
  Cell[BoxData[
      \(TraditionalForm\`sol(a, b, d, t)\)]],
  ". Calcula ahora la soluci\[OAcute]n de la ED ",
  Cell[BoxData[
      \(TraditionalForm\`y'' \((t)\) + y(t) = sol(a, b, d, t)\)]],
  " con las condiciones iniciales ",
  Cell[BoxData[
      \(TraditionalForm\`y(0) = a, \ y' \((0)\) = b\)]],
  ". Representa dicha soluci\[OAcute]n por ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(resonancia(a, b, d, t)\)\)\)]],
  ". Simplifica la soluci\[OAcute]n obtenida y comprueba que es de la forma \
",
  Cell[BoxData[
      \(TraditionalForm\`\(h(t)\) Sin[\@d\ t + \[Theta](t)]\)]],
  ". Comprueba con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que ",
  Cell[BoxData[
      \(TraditionalForm\`lim\_\(t \[Rule] \ \(+\[Infinity]\)\)h(
            t) = \(+\[Infinity]\)\)]],
  " (salvo en el caso trivial en que ",
  Cell[BoxData[
      \(TraditionalForm\`a = \(b = 0\)\)]],
  "). Representa gr\[AAcute]ficamente resonancia[1,1,4,t] junto con \
sol[1,1,4,t] en el intervalo [0,50]. Elije opciones de color apropiadas. \nb) \
Se produce resonancia siempre que se aplica una fuerza exterior \
peri\[OAcute]dica cuya frecuencia es igual a la frecuencia natural del \
sistema y cuya amplitud \"no decrece demasiado r\[AAcute]pido\". \nConsidera \
la ED ",
  Cell[BoxData[
      \(TraditionalForm\`y'' \((t)\) + 4\ \(y(t)\) = f(t)\)]],
  " a la que corresponde una frecuencia natural ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega] = 2\)]],
  " radianes/s. Representa gr\[AAcute]ficamente, eligiendo opciones \
adecuadas, la soluci\[OAcute]n de esta ED en los casos siguientes:\nb1) ",
  Cell[BoxData[
      \(TraditionalForm\`f(t) = t*Sin[2\ t]\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`f(0) = 0, f' \((0)\) = 1\)]],
  " (la amplitud de la fuerza es ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ") \nb2) ",
  Cell[BoxData[
      \(TraditionalForm\`f(t) = Sin[2\ t]\/\@t\%3\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`f(1000) = 0, f' \((1000)\) = 0\)]],
  ". En este caso calcula, usando NDSolve[ ], la soluci\[OAcute]n en el \
intervalo [1000,1050] y repres\[EAcute]ntala gr\[AAcute]ficamente en dicho \
intervalo. Observa que la amplitud de la fuerza es ",
  Cell[BoxData[
      \(TraditionalForm\`1\/\@t\%3\)]],
  "y tiende a 0, a pesar de lo cual se produce resonancia.\nb3) Procede igual \
que en el apartado b1) con ",
  Cell[BoxData[
      \(TraditionalForm\`f(t) = \(\[ExponentialE]\^\(-t\)\) Sin[2\ t]\)]],
  " (la amplitud de la fuerza es ",
  Cell[BoxData[
      \(TraditionalForm\`\[ExponentialE]\^\(-t\)\)]],
  ") . Comenta el resultado.\nc) Veamos lo que ocurre cuando aplicamos una \
fuerza exterior con una frecuencia pr\[OAcute]xima a la de resonancia. \
Considera la ED ",
  Cell[BoxData[
      \(TraditionalForm\`y'' \((t)\) + 4\ \(y(t)\) = f(t)\)]],
  " a la que corresponde una frecuencia natural ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega] = 2\)]],
  " radianes/s. Representa gr\[AAcute]ficamente, eligiendo opciones \
adecuadas, la soluci\[OAcute]n de la ED ",
  Cell[BoxData[
      \(TraditionalForm\`y'' \((t)\) + 4\ \(y(t)\) = 6  Cos[22\ t/10]\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`f(0) = 0, f' \((0)\) = 0\)]],
  ". Comprueba con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que dicha soluci\[OAcute]n es igual a ",
  Cell[BoxData[
      \(TraditionalForm\`100\/7\ Sin[t\/10]\ Sin[\(21\ t\)\/10]\)]],
  ". Representa en una misma gr\[AAcute]fica en el intervalo [0,100] las \
soluci\[OAcute]n anterior junto con las funciones ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\[PlusMinus]\(100\/7\)\)\(\ \)\(Sin[
          t\/10]\)\(\ \)\)\)]],
  ". Lo que ves se parece a un \"latido\". Es un ejemplo de sinusoide \
modulada en amplitud.\nd) Estudiemos ahora el fen\[OAcute]meno de resonancia \
cuando hay amortiguamiento.\nd1) La soluci\[OAcute]n de estado estacionario \
de la ED ",
  Cell[BoxData[
      \(TraditionalForm\`y'' \((t)\) + c\ y' \((t)\) + 9\ \(y(t)\) = 
        7\ \(cos(\[Omega]\ t)\)\)]],
  " depender\[AAcute] de las variables ",
  Cell[BoxData[
      \(TraditionalForm\`c, \ \[Omega], \ t\)]],
  ". Calcula dicha soluci\[OAcute]n y simplif\[IAcute]cala suponiendo que ",
  Cell[BoxData[
      \(TraditionalForm\`c\^2 < 36\)]],
  ". Representa dicha soluci\[OAcute]n por ",
  Cell[BoxData[
      \(TraditionalForm\`sol[c, \[Omega], t]\)]],
  ".\nLa soluci\[OAcute]n que has obtenido debe mostrar que para ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " muy grande, supuesto ",
  Cell[BoxData[
      \(TraditionalForm\`c > 0\)]],
  ", la amplitud de las oscilaciones es aproximadamente igual a ",
  Cell[BoxData[
      \(TraditionalForm\`7\ \@\(1\/\(81 + \((\(-18\) + c\^2)\)\ \[Omega]\^2 + \
\[Omega]\^4\)\)\)]],
  ".\nd2) Considerando que ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " tiene un valor fijo, con ",
  Cell[BoxData[
      \(TraditionalForm\`c\^2 < 18\)]],
  ", calcula el valor, de ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega] > 0\)]],
  " donde la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`7\ \@\(1\/\(81 + \((\(-18\) + c\^2)\)\ \[Omega]\^2 + \
\[Omega]\^4\)\)\)]],
  "alcanza un m\[AAcute]ximo absoluto. Calcula el valor de dicho \
m\[AAcute]ximo. Representa el valor correspondiente de \[Omega] por  \
\[Omega][c] (\[EAcute]ste valor es la frecuencia de resonancia que ahora \
depende del coeficiente de amortiguamiento).\nd3) Representa \
gr\[AAcute]ficamente ",
  Cell[BoxData[
      \(TraditionalForm\`sol[1 - \[Lambda], \[Omega][1 - \[Lambda]], t]\)]],
  ", en el intervalo [30000,30010], para valores de ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda] =  .9889\)]],
  " hasta ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda] =  .9999\)]],
  " con incrementos de 0.0011. Comenta lo que ves."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 5 (un ejemplo de linealizaci\[OAcute]n de una ED)", "Exercise"],

Cell[TextData[{
  "Consideremos un p\[EAcute]ndulo ideal. Se trata de un punto material de \
masa m sujeto por una varilla perfectamente r\[IAcute]gida de longitud L y \
masa despreciable que puede girar sin rozamiento alrededor de un punto fijo \
O. Suponemos que el movimiento ocurre en el plano ",
  Cell[BoxData[
      \(TraditionalForm\`X\ \(\(Y\)\(.\)\(\ \)\)\)]],
  "Elegimos el punto O como origen de coordenadas y notamos ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["i",
              FontWeight->"Bold"], "=", \((1, 0)\)}], ",", 
          RowBox[{
            StyleBox["j",
              FontWeight->"Bold"], 
            StyleBox["=",
              FontWeight->"Plain"], 
            StyleBox[\((0, 1)\),
              FontWeight->"Plain"]}]}], TraditionalForm]]],
  " los vectores de la base can\[OAcute]nica. Notamos por ",
  Cell[BoxData[
      \(TraditionalForm\`y(t)\)]],
  " la medida en radianes del \[AAcute]ngulo que forma la varilla con el \
semieje negativo de ordenadas (la vertical por O). Los \[AAcute]ngulos se \
miden hacia la derecha con valores positivos y hacia la izquierda con valores \
negativos."
}], "ExerciseText"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .71875 
%%ImageSize: 144 103.5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0625 0.5625 0.0625 [
[ 0 0 0 0 ]
[ 1 .71875 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .71875 L
0 .71875 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 g
.003 w
[ ] 0 setdash
.5 .5625 m
.5 .0625 L
s
0 .1 1 r
.03 w
.1875 .0625 m
.8125 .0625 L
s
0 g
.0065 w
.5 .5625 m
.77063 .40625 L
s
1 0 0 r
.77063 .40625 m
.77063 .40625 .02083 0 365.73 arc
F
0 g
.015 w
.77063 .40625 Mdot
.02 w
.5 .5625 Mdot
.5 Mabswid
.5 .40625 m
.5002 .40625 L
.50039 .40625 L
.5006 .40625 L
.5008 .40625 L
.50116 .40625 L
.50154 .40626 L
.50197 .40626 L
.50242 .40627 L
.50323 .40628 L
.50407 .4063 L
.50485 .40633 L
.50664 .40639 L
.50845 .40648 L
.51012 .40658 L
.51386 .40687 L
.5171 .40719 L
.52064 .40762 L
.52754 .4087 L
.53413 .41002 L
.54106 .41174 L
.54766 .4137 L
.55392 .41585 L
.56048 .41843 L
.56667 .42119 L
.57251 .4241 L
.57859 .42745 L
.5843 .43094 L
.59019 .43491 L
.59569 .43898 L
.60081 .44312 L
.60606 .44776 L
.61092 .45245 L
.61539 .45714 L
.61993 .46235 L
.62408 .46754 L
.62825 .47324 L
.63201 .47892 L
.63532 .48437 L
s
gsave
.59375 .40012 -71 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
64.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
69.000 15.000 moveto
(H) show
73.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
76.000 15.000 moveto
(L) show
79.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.6395 .55413 -66 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(L) show
69.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
newpath
.5 .5625 .3125 0 365.73 arc
s
.77063 .40625 m
.66238 .21875 L
s
% Start of user PostScript
4.33013 -2.5 2.59808 -5.5 MAarrowhead1
% End of user PostScript
.77063 .40625 m
.87889 .34375 L
s
% Start of user PostScript
4.33013 -2.5 6.06218 -3.5 MAarrowhead1
% End of user PostScript
.77063 .40625 m
.66238 .46875 L
s
% Start of user PostScript
4.33013 -2.5 2.59808 -1.5 MAarrowhead1
% End of user PostScript
.77063 .40625 m
.77063 .15625 L
s
% Start of user PostScript
4.33013 -2.5 4.33013 -6.5 MAarrowhead1
% End of user PostScript
gsave
.84375 .2625 -70 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
64.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(mg) show
77.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.5 .61875 -66.5 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(O) show
70.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{144, 103.5},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003H0000Vb000`400?l00000o`00003of03oool0
0=P0oooo003H0?ooo`00f03oool00=P0oooo003H0?ooo`00f03oool00=P0oooo003H0?ooo`00f03o
ool00=P0oooo003H0?ooo`009@3ooon<000IobL0oooo000U0?oooh`001Wo9`3oool002D0ooooS000
6OlW0?ooo`009@3ooon<000IobL0oooo000U0?oooh`001Wo9`3oool002D0ooooS0006OlW0?ooo`00
J`3oool00`000000oooo0?ooo`1Z0?ooo`00J`3oool00`000000oooo0?ooo`1Z0?ooo`00J`3oool0
0`000000oooo0?ooo`1Z0?ooo`00J`3oool00`000000oooo0?ooo`1Z0?ooo`00J`3oool00`000000
oooo0?ooo`1Z0?ooo`00J`3oool00`000000oooo0?ooo`1Z0?ooo`00J`3oool00`000000oooo0?oo
o`1Z0?ooo`00J`3oool00`000000oooo0?ooo`1Z0?ooo`00J`3oool00`000000oooo0?ooo`1Z0?oo
o`00J`3oool00`000000oooo0?ooo`1Z0?ooo`00J`3oool00`000000oooo0?ooo`1Z0?ooo`00J`3o
ool00`000000oooo0?ooo`1Z0?ooo`00J`3oool00`000000oooo0?ooo`1Z0?ooo`00J`3oool00`00
0000oooo0?ooo`1Z0?ooo`00J`3oool00`000000oooo0?ooo`1Z0?ooo`00J`3oool00`000000oooo
0?ooo`1Z0?ooo`00J`3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo0300oooo001[
0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool0<03oool006/0oooo00<000000?oo
o`3oool0=P3oool300000340oooo001[0?ooo`030000003oool0oooo03H0oooo0`00000a0?ooo`00
J`3oool00`000000oooo0?ooo`0f0?ooo`<00000<@3oool006/0oooo00<000000?ooo`3oool0=P3o
ool300000340oooo001[0?ooo`030000003oool0oooo03D0oooo1@00000`0?ooo`00J`3oool00`00
0000oooo0?ooo`0e0?ooo`D00000<03oool006/0oooo00<000000?ooo`3oool0=@3oool500000300
oooo001[0?ooo`030000003oool0oooo03D0oooo1@00000`0?ooo`00J`3oool00`000000oooo0?oo
o`0d0?ooo`L00000;`3oool006/0oooo00<000000?ooo`3oool0=03oool7000002l0oooo001[0?oo
o`030000003oool0oooo03L0oooo00<000000?ooo`3oool0<03oool006/0oooo00<000000?ooo`3o
ool0803oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0300oooo001[0?ooo`030000
003oool0oooo0200oooo0P00000E0?ooo`030000003oool0oooo0300oooo001[0?ooo`030000003o
ool0oooo0240oooo0P00000D0?ooo`030000003oool0oooo00l0oooo00<0oooD09/0000000000P00
00000`1b^^X0oooo0?ooo`0I0?ooo`00J`3oool00`000000oooo0?ooo`0Q0?ooo`<000004`3oool0
0`000000oooo0?ooo`0?0?ooo`030=BK0000Vm@0oooo0080oooo00<0j[Yb09_Do`3oool06@3oool0
06/0oooo00<000000?ooo`3oool08@3oool400000180oooo00<000000?ooo`3oool03`3oool00`3o
om@0^[[Z0?ooo`020?ooo`030?oZ^P1bVm@0oooo01T0oooo001[0?ooo`030000003oool0oooo0240
oooo1@00000A0?ooo`030000003oool0oooo00<0oooo00h0oooD09/000000000001b0;[Ze02K0000
00000000LP2jj]@0V`000000000009/0e?oZ0;Yb00@0000000<0VmCo0?ooo`3oool0603oool006/0
oooo00<000000?ooo`3oool08P3oool500000100oooo00<000000?ooo`3oool0103oool03P3oj[X0
LP1b0;[Zo`3oool0onZj0780LP2jj_l0oooo0?oZ^P1b0780^^[o0?ooe02KL[X0j_oo7P3oool006<0
oooo4@00000L0?ooo`H000003`3oool00`000000oooo0?ooo`040?ooo`0A0?oZ^P1b0780^^[o0?oo
o`3oj[X0LP1b0;[Zo`3oool0onZj0780LP2jj_l0oooo0?oZ^P1b000000000000V`3Dool06`3oool0
05h0oooo1@0000080?ooo`030000003oool0oooo00H0oooo1@00000G0?ooo`L000003P3oool00`00
0000oooo0?ooo`040?ooo`0A0?oZ^P1b0780^^[o0?ooo`3oj[X0LP1b0;[Zo`3oool0onZj0780LP2j
j_l0oooZ0;Yb001b^^X0oooo0>ZjLP00Vm@06`3oool005T0oooo1@00000=0?ooo`030000003oool0
oooo00/0oooo1@00000B0?ooo`H000003`3oool00`000000oooo0?ooo`040?ooo`0B0?oZ^P1b0780
^^[o0?ooo`3oj[X0LP1b0;[Zo`3oool0onZj0780LP2jj_l0onZj0780LP2jj_l0oooo0?oDV`00L[X0
j_oo6P3oool005H0oooo0`00000B0?ooo`030000003oool0oooo0100oooo0`00000@0?ooo`@00000
403oool00`000000oooo0?ooo`030?ooo`0B0?oZ^P1b000000000000V`3Dool0omBK0000000009/0
e?oo0?oDV`0009/0e?oo0?ooe02K0000VmCo0?ooo`3DV`0009_D6`3oool005@0oooo0P00000E0?oo
o`030000003oool0oooo01<0oooo0P00000>0?ooo`040000003oool0oooo00000100oooo00<00000
0?ooo`3oool0103oool02P3oj[X0LP1b0;[Ze02K00000000002Ke03oom@0V`000000001b^^X20?oo
o`030?oZ^P1b000000000080000000<007:j0>[oo`3oool0603oool00540oooo0`00000G0?ooo`03
0000003oool0oooo01D0oooo0`00000?0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool0<03oool004h0oooo0`00000J0?ooo`030000003oool0oooo01P0oooo0`00000<0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool0<03oool004`0oooo0P00000M0?ooo`030000003o
ool0oooo01/0oooo0P00000;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0<03o
ool004X0oooo0P00000O0?ooo`030000003oool0oooo01d0oooo0P00000:0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0<03oool004T0oooo00<000000?ooo`3oool07`3oool00`00
0000oooo0?ooo`0O0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0`0?ooo`00B03oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo0200
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0300
oooo00170?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool08@3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0<03oool004D0oooo0P00
000T0?ooo`030000003oool0oooo0280oooo0P0000070?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool0<03oool004@0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0T
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0`
0?ooo`00@P3oool2000002L0oooo00<000000?ooo`3oool09@3oool2000000D0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`0`0?ooo`00@@3oool00`000000oooo0?ooo`0W0?ooo`03
0000003oool0oooo02L0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo0300oooo00100?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0
:03oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
<03oool003l0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0Y0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0`0?ooo`00?@3oool2
000002`0oooo00<000000?ooo`3oool0:P3oool200000080oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`0`0?ooo`00?03oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo
02`0oooo00@000000?ooo`3oool000001`3oool00`000000oooo0?ooo`0`0?ooo`00>`3oool00`00
0000oooo0?ooo`0]0?ooo`030000003oool0oooo02d0oooo00@000000?ooo`3oool000001P3oool0
0`000000oooo0?ooo`0C0?ooo`8000006`3oool003X0oooo00<000000?ooo`3oool0;P3oool00`00
0000oooo0?ooo`0^0?ooo`030000003oool0000000H0oooo00<000000?ooo`3oool0403oool40000
01`0oooo000i0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool0;`3oool00`000000
oooo000000050?ooo`030000003oool0oooo00`0oooo1`00000M0?ooo`00>@3oool00`000000oooo
0?ooo`0_0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`0000001@3oool00`000000oooo
0?ooo`0:0?ooo`P000007P3oool003P0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?oo
o`070?ooo`030>ZjLP00000009_D00L0oooo00<0e9/009_Do`3oool01@3oool00`3oe9/009_D0?oo
o`0D0?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool02P3oool7000001l0oooo000g
0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool02@3oool00`3oe9/0VmCo0?ooo`04
0?ooo`030>ZjLP2Ke?l0oooo00L0oooo00<0omBK07:jjP3oool0503oool2000000@0oooo00<00000
0?ooo`3oool02`3oool500000200oooo000f0?ooo`030000003oool0oooo0380oooo00<000000?oo
o`3oool02@3oool00`3oonX0^Y^j0>[oo`030?ooo`030?oZ^P1bVm@0oooo00T0oooo00<0e9]b0;[Z
o`3oool0503oool2000000<0oooo00<000000?ooo`3oool02@3oool600000240oooo000e0?ooo`03
0000003oool0oooo03<0oooo00<000000?ooo`3oool02P3oool00`3Z^Y/0^^[o0?ooo`020?ooo`03
0=BK002Ke?l0oooo00<0oooo00@0e9/000000000L[X0j_oo0P3oool00`3oe9/009_D0?ooo`0E0?oo
o`8000000P3oool00`000000oooo0?ooo`070?ooo`8000000`3oool200000280oooo000e0?ooo`03
0000003oool0oooo03<0oooo00<000000?ooo`3oool02@3oool00`3oom@0V`0007:jjP020?ooo`03
0?ooe02K0780^^[o00<0oooo00<0oooD09/0002Ke?l0103oool00`3oj[X0LP2K0=Coo`0E0?ooo`80
00000P3oool00`000000oooo0?ooo`050?ooo`8000001@3oool00`000000oooo0?ooo`0Q0?ooo`00
=03oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo00T0oooo00P0j[Yb001bV`2KLY/0
e?oo0?ooo`3oj[X0LP2K0=Coo`<0oooo00<0oooD09/0002Ke?l0103oool00`3oom@0V`1b0;[Zo`0F
0?ooo`80000000<0oooo0000003oool01@3oool00`000000oooo0?ooo`0Y0?ooo`00<`3oool00`00
0000oooo0?ooo`0e0?ooo`030000003oool0oooo00P0oooo00T0oooD09/0002Ke?l0omBK09_Do`3o
ool0onZj0780V`3Dool00`3oool00`3oom@0V`0009_Do`040?ooo`030?ooe02K0780^^[o01H0oooo
00@0o`000000003o000000000P3o00020?ooo`800000;03oool003<0oooo00<000000?ooo`3oool0
=@3oool00`000000oooo0?ooo`080?ooo`090>ZjLP00Vm@0oooo0?oojP2jVkX0j_oo0?oZ^P1b09/0
e?oo00<0oooo00<0oooD09/0002Ke?l0103oool00`3oom@0V`1b0;[Zo`0E0?ooo`80o`000`000002
0?l000800000;P3oool00380oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`070?oo
o`030?ooe02K0000VmCo0080oooo00D0j[ZK0;[Zo`3oj[X0LP2K0=Coo`030?ooo`030?ooe02K0000
VmCo00@0oooo00<0oooD09/0LP2jj_l05@3oool30?l000@0000000<0o`000?ooo`3oool0;@3oool0
0340oooo00<000000?ooo`3oool0=`3oool3000000H0oooo00/0oooZ0;Yb00000000002K0=Coo`3o
om@0V`000000V`3Dom@0V`1b0;[Zo`020?ooo`060?oZ^P1b0000000000000000L[X0j_oo0P3oool0
0`3oj[X0LP2K0=Coo`0E0?ooo`<0o`000`0000030?l002h0oooo000a0?ooo`030000003oool0oooo
03L0oooo00<000000?ooo`0000001@00000:0?ooo`030=BK002Ke?l0oooo0080oooo00<0oooZ0;Yb
002Ke?l0103oool00`3oe9/009_D0?ooo`0E0?ooo`80o`000`0000040?l002h0oooo000`0?ooo`03
0000003oool0oooo03P0oooo00<000000?ooo`3oool01@3oool5000000D0oooo00<0onZj07:Ke03o
ool00`3oool00`3oe9/0VmCo0?ooo`030?ooo`030=BKLP2jj_l0oooo01D0oooo0P0000030?l00003
0000003o0000o`0002l0oooo000`0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`030?ooo`030>ZjLP00Vm@0oooo00L0oooo00<0e9/007:jjP3oool0
5@3oool00`000000oooo0?l000030?l000030000003o0000o`0002l0oooo000_0?ooo`030000003o
ool0oooo03T0oooo00<000000?ooo`3oool02`3oool3000000<0oooo00<0omBj0;[Zo`3oool01@3o
ool00`3oj[X0^]Co0?ooo`0D0?ooo`8000000`3oool40?l000030000003oool0oooo02h0oooo000_
0?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0M
0?ooo`8000001@3oool40?l000030000003oool0oooo02h0oooo000^0?ooo`030000003oool0oooo
03X0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0F0?ooo`040000003oool0oooo
0?ooo`800000303oool00`000000oooo0?ooo`0]0?ooo`00;@3oool00`000000oooo0?ooo`0k0?oo
o`030000003oool0oooo0100oooo0`00000D0?ooo`8000000P3oool2000000d0oooo00<000000?oo
o`3oool0;@3oool002d0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0C0?ooo`03
0000003oool0oooo0100oooo1@00000@0?ooo`030000003oool0oooo02`0oooo000]0?ooo`030000
003oool0oooo03/0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0>0?ooo`D00000
4@3oool00`000000oooo0?ooo`0/0?ooo`00;03oool00`000000oooo0?ooo`0l0?ooo`030000003o
ool0oooo01D0oooo00<000000?ooo`3oool0303oool700000100oooo00<000000?ooo`3oool0;03o
ool002`0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`0F0?ooo`030000003oool0
oooo00X0oooo2000000A0?ooo`030000003oool0oooo02/0oooo000[0?ooo`030000003oool0oooo
03d0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`080?ooo`L000004`3oool00`00
0000oooo0?ooo`0[0?ooo`00:`3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo01L0
oooo00<000000?ooo`3oool01P3oool6000001L0oooo00<000000?ooo`3oool0:P3oool002/0oooo
00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00@0oooo
0`00000K0?ooo`030000003oool0oooo02X0oooo000Z0?ooo`030000003oool0oooo03h0oooo00<0
00000?ooo`3oool06@3oool010000000oooo0?ooo`3oool2000001h0oooo00<000000?ooo`3oool0
:P3oool002X0oooo00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`0I0?ooo`040000003o
ool0000000000240oooo00<000000?ooo`3oool0:@3oool002X0oooo00<000000?ooo`3oool0?P3o
ool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0:@3o
ool002X0oooo00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`0H0?ooo`800000903oool0
0`000000oooo0?ooo`0Y0?ooo`00:P3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo
01H0oooo0P00000V0?ooo`030000003oool0oooo02T0oooo000Y0?ooo`030000003oool0oooo03l0
oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02T0
oooo000Y0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool04`3oool2000002X0oooo
00<000000?ooo`3oool0:03oool002T0oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?oo
o`0A0?ooo`800000;03oool00`000000oooo0?ooo`0X0?ooo`00:@3oool00`000000oooo0?ooo`0o
0?ooo`030000003oool0oooo00l0oooo0P00000^0?ooo`030000003oool0oooo02P0oooo000Y0?oo
o`030000003oool0oooo03l0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0^0?oo
o`030000003oool0oooo02P0oooo000X0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3o
ool0303oool200000340oooo00<000000?ooo`3oool0:03oool002P0oooo00<000000?ooo`3oool0
@03oool00`000000oooo0?ooo`0:0?ooo`800000=03oool00`000000oooo0?ooo`0W0?ooo`00:03o
ool00`000000oooo0?ooo`100?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3o
ool00`3oonX0^W800000000500000003001b^P3Zool0oooo0200oooo00<000000?ooo`3oool09`3o
ool002P0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`070?ooo`8000003P3oool0
0`3Z^W8007:j0>[oo`020?ooo`030?ooe02K09/0e?oo0240oooo00<000000?ooo`3oool09`3oool0
02P0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`050?ooo`800000403oool00`3o
e9/007:j0>[oo`030?ooo`030?oDV`2Ke?l0oooo0200oooo00<000000?ooo`3oool09`3oool002P0
oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`030?ooo`8000004P3oool00`3oe9/0
07:j0>[oo`0V0?ooo`030000003oool0oooo02L0oooo000X0?ooo`030000003oool0oooo0400oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0B0?ooo`030?oDV`00L[X0j_oo02H0oooo
00<000000?ooo`3oool09`3oool002P0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?oo
o`02000001D0oooo00<0omBK001b^P3Zool09P3oool00`000000oooo0?ooo`0W0?ooo`00:03oool0
0`000000oooo0?ooo`0o0?ooo`@000005`3oool00`3oe9/007:j0>[oo`0V0?ooo`030000003oool0
oooo02L0oooo000X0?ooo`030000003oool0oooo03h0oooo1000000H0?ooo`030?oDV`00L[X0j_oo
02H0oooo00<000000?ooo`3oool09`3oool002P0oooo00<000000?ooo`3oool0?P3oool4000001P0
oooo00<0j[Yb001b^P3Zool09P3oool00`000000oooo0?ooo`0W0?ooo`00:03oool00`000000oooo
0?ooo`0o0?ooo`8000005`3oool01P3oonX0^W80000000000000001b0;[ZobD0oooo00<000000?oo
o`3oool09`3oool002P0oooo00<000000?ooo`3oool0P`3oool00`000000oooo0?ooo`0W0?ooo`00
:03oool00`000000oooo0?ooo`230?ooo`030000003oool0oooo02L0oooo000X0?ooo`030000003o
ool0oooo08<0oooo00<000000?ooo`3oool09`3oool002P0oooo00<000000?ooo`3oool0P`3oool0
0`000000oooo0?ooo`0W0?ooo`00:03oool00`000000oooo0?ooo`0m0?ooo`030?oojP2jLP000000
0080000000<009_D0?ooo`3oool0?P3oool00`000000oooo0?ooo`0W0?ooo`00:03oool00`000000
oooo0?ooo`0l0?ooo`030?oZ^P1b000009_D00<0oooo00<0e9/00000V`3Dool0?P3oool00`000000
oooo0?ooo`0W0?ooo`00:03oool00`000000oooo0?ooo`0k0?ooo`040?oojP2jLP0007:j0>[oo`<0
oooo00@0oooZ0;Yb0000L[X0j_oo?03oool00`000000oooo0?ooo`0X0?ooo`00:@3oool00`000000
oooo0?ooo`0j0?ooo`030?oZ^P1b0000L[[Z00D0oooo00<0j[Yb0000LP2jj_l0?03oool00`000000
oooo0?ooo`0X0?ooo`00:@3oool00`000000oooo0?ooo`0j0?ooo`030?oDV`000000VmCo00D0oooo
00<0omBK0000002Ke?l0?03oool00`000000oooo0?ooo`0X0?ooo`00:@3oool00`000000oooo0?oo
o`0j0?ooo`030?oDV`000000VmCo00D0oooo00<0omBK0000002Ke?l0?03oool00`000000oooo0?oo
o`0X0?ooo`00:@3oool00`000000oooo0?ooo`0j0?ooo`030?oZ^P1b0000L[[Z00D0oooo00<0j[Yb
0000LP2jj_l0?03oool00`000000oooo0?ooo`0X0?ooo`00:@3oool00`000000oooo0?ooo`0j0?oo
o`040?oojP2jLP0007:j0>[oo`<0oooo00@0oooZ0;Yb0000L[X0j_oo>`3oool00`000000oooo0?oo
o`0Y0?ooo`00:P3oool00`000000oooo0?ooo`0j0?ooo`030?ooe02K000009_D00<0oooo00<0e9/0
0000V`3Dool0?03oool00`000000oooo0?ooo`0Y0?ooo`00:P3oool00`000000oooo0?ooo`0l0?oo
o`050=BK00000000000000000000Vm@0?P3oool00`000000oooo0?ooo`0Y0?ooo`00:P3oool00`00
0000oooo0?ooo`1o0?ooo`030000003oool0oooo02T0oooo000Z0?ooo`030000003oool0oooo07l0
oooo00<000000?ooo`3oool0:@3oool002X0oooo00<000000?ooo`3oool0OP3oool00`000000oooo
0?ooo`0Z0?ooo`00:`3oool00`000000oooo0?ooo`1m0?ooo`030000003oool0oooo02X0oooo000[
0?ooo`030000003oool0oooo07d0oooo00<000000?ooo`3oool0:P3oool002/0oooo00<000000?oo
o`3oool0O03oool00`000000oooo0?ooo`0[0?ooo`00;03oool00`000000oooo0?ooo`1k0?ooo`03
0000003oool0oooo02/0oooo000]0?ooo`030000003oool0oooo07T0oooo00<000000?ooo`3oool0
;03oool002d0oooo00<000000?ooo`3oool0N@3oool00`000000oooo0?ooo`0/0?ooo`00;@3oool0
0`000000oooo0?ooo`1i0?ooo`030000003oool0oooo02`0oooo000]0?ooo`030000003oool0oooo
07P0oooo00<000000?ooo`3oool0;@3oool002h0oooo00<000000?ooo`3oool0M`3oool00`000000
oooo0?ooo`0]0?ooo`00;`3oool00`000000oooo0?ooo`1e0?ooo`030000003oool0oooo02h0oooo
000_0?ooo`030000003oool0oooo07D0oooo00<000000?ooo`3oool0;P3oool00300oooo00<00000
0?ooo`3oool0L`3oool00`000000oooo0?ooo`0_0?ooo`00<03oool00`000000oooo0?ooo`1c0?oo
o`030000003oool0oooo02l0oooo000a0?ooo`030000003oool0oooo0740oooo00<000000?ooo`3o
ool0<03oool00001\
\>"],
  ImageRangeCache->{{{0, 215}, {154.25, 0}} -> {-8.01467, -9.00006, 0.111833, \
0.111833}}],

Cell[TextData[{
  "El punto m est\[AAcute] obligado a moverse en una circunferencia de centro \
O y radio L y queremos que inicialmente est\[EAcute] en la posici\[OAcute]n \
de reposo ",
  Cell[BoxData[
      \(TraditionalForm\`\((0, \(-L\))\)\)]],
  " por lo que su trayectoria viene dada por ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox["(",
              FontWeight->"Plain",
              FontSlant->"Italic"], 
            StyleBox["t",
              FontWeight->"Plain",
              FontSlant->"Italic"], 
            StyleBox[")",
              FontWeight->"Plain",
              FontSlant->"Italic"]}], 
          StyleBox["=",
            FontWeight->"Plain",
            FontSlant->"Italic"], 
          StyleBox[\(L(sen(y(t)), \(-\(cos(y(t))\)\))\),
            FontWeight->"Plain",
            FontSlant->"Italic"]}], TraditionalForm]]],
  ". Se supone que la \[UAcute]nica fuerza que act\[UAcute]a en cada momento \
es la de la gravedad ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"], 
          StyleBox["=",
            FontWeight->"Plain",
            FontSlant->"Plain"], 
          RowBox[{
            StyleBox[\(-mg\),
              FontWeight->"Plain",
              FontSlant->"Plain"], 
            StyleBox[" ",
              FontWeight->"Plain",
              FontSlant->"Plain"], 
            StyleBox["j",
              FontWeight->"Bold",
              FontSlant->"Italic"]}]}], TraditionalForm]]],
  ". En cada punto de la trayectoria podemos descomponer dicha fuerza en sus \
proyecciones sobre la tangente unitaria, ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          SubscriptBox[
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"], "t"],
          FontWeight->"Bold"], TraditionalForm]]],
  ", y sobre la normal unitaria, ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          SubscriptBox[
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"], "n"],
          FontWeight->"Bold"], TraditionalForm]]],
  ". La componente normal ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          SubscriptBox[
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"], "n"],
          FontWeight->"Bold"], TraditionalForm]]],
  " queda anulada por la reacci\[OAcute]n de la varilla y la \[UAcute]nica \
fuerza que interviene es la debida a la componente tangencial. Descomponiendo \
tambi\[EAcute]n la aceleraci\[OAcute]n en sus componentes normal y tangencial \
y, teniendo en cuenta que la aceleraci\[OAcute]n normal queda anulada por la \
varilla, habr\[AAcute] de cumplirse, en virtud de la segunda ley de Newton, \
que la masa por la componente tangencial de la aceleraci\[OAcute]n sea igual \
a la componente tangencial de la fuerza de gravedad. Podemos hacer los c\
\[AAcute]lculos con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Recuerda que si ",
  Cell[BoxData[
      FormBox[
        StyleBox["Y",
          FontWeight->"Bold",
          FontSlant->"Italic"], TraditionalForm]]],
  " es un vector unitario y ",
  Cell[BoxData[
      FormBox[
        StyleBox["X",
          FontWeight->"Bold",
          FontSlant->"Italic"], TraditionalForm]]],
  " es un vector cualquiera, la proyecci\[OAcute]n (ortogonal) de ",
  Cell[BoxData[
      FormBox[
        StyleBox["X",
          FontWeight->"Bold",
          FontSlant->"Italic"], TraditionalForm]]],
  " sobre ",
  Cell[BoxData[
      FormBox[
        StyleBox["Y",
          FontWeight->"Bold",
          FontSlant->"Italic"], TraditionalForm]]],
  " es el vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"(", 
            StyleBox[\(X . Y\),
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox[")",
              FontWeight->"Bold",
              FontSlant->"Italic"]}], 
          StyleBox["Y",
            FontWeight->"Bold",
            FontSlant->"Italic"]}], TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(X . Y\),
          FontWeight->"Bold",
          FontSlant->"Italic"], TraditionalForm]]],
  " es el producto escalar (eucl\[IAcute]deo) de ambos vectores."
}], "ExerciseText"],

Cell[BoxData[{
    \(\(r[t_] = L {Sin[y[t]], \(-Cos[y[t]]\)};\)\  (*\ 
      trayectoria\ *) \), "\[IndentingNewLine]", 
    \(\(tgtunit[t_] = {Cos[y[t]], Sin[y[t]]};\)\  (*\ 
      tangente\ unitaria\ *) \), "\[IndentingNewLine]", 
    \(\(F[t_] = {0, \(-m\)\ g}\  (*\ 
        fuerza\ de\ la\ gravedad\ *) ;\)\), "\[IndentingNewLine]", 
    \(F\_T[t_] = \((F[t] . tgtunit[t]\ )\)*tgtunit[t] // Simplify (*\ 
      componente\ tangencial\ de\ la\ fuerza\ *) \), "\[IndentingNewLine]", 
    \(a\_T[t_] = \((\(r''\)[t] . tgtunit[t])\)*tgtunit[t] // Simplify (*\ 
      componente\ tangencial\ de\ la\ aceleraci\[OAcute]n\ *) \), "\
\[IndentingNewLine]", 
    \(Reduce[m*a\_T[t] \[Equal] F\_T[t], \(y''\)[t]] (*\ 
      Mathematica\ reduce\ esta\ igualdad\ *) \ \)}], "Input"],

Cell[TextData[{
  "De las respuestas que da ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " es claro que la igualdad ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"m", " ", 
            StyleBox[\(a\_t\),
              FontWeight->"Bold"]}], "=", 
          StyleBox[
            SubscriptBox[
              StyleBox["F",
                FontWeight->"Bold",
                FontSlant->"Italic"], "t"],
            FontWeight->"Bold"]}], TraditionalForm]]],
  " equivale a que se verifique la igualdad ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], 
          "\[Equal]", \(-\(\(g\ Sin[y[t]]\)\/L\)\)}], TraditionalForm]]],
  ", esto es ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "t", "]"}], 
            "+", \(g\/L\ Sin[y[t]]\)}], "=", "0"}], TraditionalForm]]],
  ". Esta es la ED del p\[EAcute]ndulo. Se trata de una ED no lineal. Parece \
sencilla pero no lo es. "
}], "ExerciseText"],

Cell[BoxData[
    \(DSolve[{\(y''\)[t] + \(g\/L\) Sin[y[t]] \[Equal] 0, 
        y[0] \[Equal] 0, \(y'\)[0] \[Equal] 1}, y, t]\)], "Input"],

Cell[TextData[{
  "a) Define un comando, al que llamar\[AAcute]s ",
  Cell[BoxData[
      \(TraditionalForm\`sol[a, b]\)]],
  ", que cuando se particularicen valores num\[EAcute]ricos para ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " y para ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  " proporcione la soluci\[OAcute]n num\[EAcute]rica, calculada con NDSolve[ \
], de la ED del p\[EAcute]ndulo (con ",
  Cell[BoxData[
      \(TraditionalForm\`L = 10\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`g = 9.8\)]],
  ") con condiciones iniciales ",
  Cell[BoxData[
      \(TraditionalForm\`y[0] = a\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(y'\)[0] = b\)]],
  " en el intervalo [0,30]. \na1) Representa gr\[AAcute]ficamente ",
  Cell[BoxData[
      \(TraditionalForm\`\(sol[a, b]\)[t]\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`a = 0.2\)]],
  " tomando ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  " valores desde 0.25 hasta 3 con incrementos de 0.25. Sugerencia: Usa \
Evaluate[sol[a,b][t]] en el comando Plot[ ] (para que sea m\[AAcute]s r\
\[AAcute]pido).\na2) Representa gr\[AAcute]ficamente ",
  Cell[BoxData[
      \(TraditionalForm\`\(sol[a, b]\)[t]\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`b = 0.5\)]],
  " tomando ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " valores desde 0.25 hasta 5 con incrementos de 0.25. Sugerencia: Usa \
Evaluate[sol[a,b][t]] en el comando Plot[ ] (para que sea m\[AAcute]s r\
\[AAcute]pido).\nA la vista de los resultados anteriores debes tener claro \
que cuando las condiciones iniciales son n\[UAcute]meros peque\[NTilde]os la \
soluci\[OAcute]n se parece mucho a un movimiento arm\[OAcute]nico simple, \
pero no es as\[IAcute] cuando las condiciones iniciales son relativamente \
grandes. \[DownQuestion]Qu\[EAcute] movimiento arm\[OAcute]nico simple es el \
candidato para aproximar el movimiento real del p\[EAcute]ndulo con \
condiciones iniciales peque\[NTilde]as? Veamos. La ED del p\[EAcute]ndulo es \
",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "t", "]"}], 
            "+", \(g\/L\ Sin[y[t]]\)}], "=", "0"}], TraditionalForm]]],
  ". Esta ED no es f\[AAcute]cil de resolver. Para valores peque\[NTilde]os \
de ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  " sabemos que Sin[z] est\[AAcute] muy pr\[OAcute]ximo de ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  " (recuerda que  ",
  Cell[BoxData[
      \(TraditionalForm\`lim\_\(z \[Rule] 0\)Sin[z]\/z = 1\)]],
  "), por eso, cuando ",
  Cell[BoxData[
      \(TraditionalForm\`y(t)\)]],
  " es peque\[NTilde]o podemos sustituir ",
  Cell[BoxData[
      \(TraditionalForm\`Sin[y[t]]\)]],
  " por ",
  Cell[BoxData[
      \(TraditionalForm\`y[t]\)]],
  ", obtenemos as\[IAcute] la ED ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          FormBox[
            RowBox[{
              RowBox[{
                RowBox[{
                  SuperscriptBox["y", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}], 
                "+", \(g\/L\ y[t]\)}], "=", "0"}],
            "TraditionalForm"]}], TraditionalForm]]],
  " cuya soluci\[OAcute]n sabemos que es un movimiento arm\[OAcute]nico \
simple con frecuencia ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(g\/L\)\)]],
  ". La enorme ventaja de esta ED es que es lineal y su estudio, como ya \
sabes, bien f\[AAcute]cil.\nb) Define un comando, al que llamar\[AAcute]s ",
  Cell[BoxData[
      \(TraditionalForm\`solaprox[a, b, t]\)]],
  ", que cuando se particularicen valores num\[EAcute]ricos para ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " y para ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  " proporcione la soluci\[OAcute]n, calculada con DSolve[ ], de la ED del p\
\[EAcute]ndulo (con ",
  Cell[BoxData[
      \(TraditionalForm\`L = 10\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`g = 98\)]],
  "/10) con condiciones iniciales ",
  Cell[BoxData[
      \(TraditionalForm\`y[0] = a\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(y'\)[0] = b\)]],
  ".\nb1) Representa en una misma gr\[AAcute]fica ",
  Cell[BoxData[
      \(TraditionalForm\`\(sol[a, b]\)[t]\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`solaprox[a, b, t]\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`a = 0.2\)]],
  " tomando ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  " valores desde 0.25 hasta 3 con incrementos de 0.25. Comenta lo que ves.\n\
b2) Representa en una misma gr\[AAcute]fica ",
  Cell[BoxData[
      \(TraditionalForm\`\(sol[a, b]\)[t]\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`solaprox[a, b, t]\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`b = 0.5\)]],
  " tomando ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " valores desde 0.25 hasta 5 con incrementos de 0.25. Comenta lo que ves."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 6 (optativo)", "Exercise"],

Cell[TextData[{
  "Demuestra con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que la soluci\[OAcute]n de estado estacionario de una EDL con \
coeficientes constantes de la forma"
}], "ExerciseText"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`\(\(y\^\((n)\)\)(
              t) + \(c\_\(n - 1\)\) \(\(y\^\((n - 1)\)\)(
                t)\) +  ... \) + \(c\_1\) y' \((t)\) + \(c\_0\) \(y(t)\) = 
      f(t)\)]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "viene dada por la integral de convoluci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\_0\%t\( f(x)\) \(imp(
            t - x)\) \[DifferentialD]x\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`imp \((t)\)\)]],
  " es la soluci\[OAcute]n del PVI"
}], "ExerciseText"],

Cell[TextData[Cell[BoxData[{
    \(TraditionalForm\`\(\(y\^\((n)\)\)(
              t) + \(c\_\(n - 1\)\) \(\(y\^\((n - 1)\)\)(
                t)\) +  ... \) + \(c\_1\) y' \((t)\) + \(c\_0\) \(y(t)\) = 
      0\), "\[IndentingNewLine]", 
    \(TraditionalForm\`\(\(y\^\((n - 2)\)\)(0) =. \) ..  = \(y' \((0)\) = \(y(
            0) = 0\)\), \ \(y\^\((n - 1)\)\)(0) = 1\)}]]], "Text",
  TextAlignment->Center]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 7", "Exercise"],

Cell[TextData[{
  "Usa la transformada de Laplace para calcular las soluciones de las \
siguientes EDs con las condiciones indicadas en cada caso. \na) ",
  Cell[BoxData[
      \(TraditionalForm\`y''' \((t)\) - 3  y'' \((t)\) + 3  y' \((t)\) - 
          y(t) = \(t\^2\) \[ExponentialE]\^t, \ y(0) = 1, \ y' \((0)\) = 0, \ 
      y'' \((0)\) = \(-2. \)\)]],
  "\nb)",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(y'' \((t)\) + 9 \( y(t)\) = cos(2  t), \ 
      y(0) = 1, y(\[Pi]/2) = \(-1\)\)\)\)]],
  ".\nc) ",
  Cell[BoxData[
      \(TraditionalForm\`t\ y'' \((t)\) + 2  y' \((t)\) + t\ \(y(t)\) = 0, \ 
      y(0) = 1, \ y' \((\[Pi])\) = 0\)]],
  ".\n\nd) ",
  Cell[BoxData[
      FormBox[
        TagBox[
          StyleBox[
            RowBox[{"{", 
              StyleBox[GridBox[{
                    {\(x'' \((t)\) + y' \((t)\) + 3 \( x(t)\) = 
                        15  \[ExponentialE]\^\(-t\)\)},
                    {\(y'' \((t)\) - 4  x' \((t)\) + 3 \( y(t)\) = 
                        15\ \(sen(2  t)\)\)}
                    }],
                ShowAutoStyles->True]}],
            ShowAutoStyles->False],
          (#&)], TraditionalForm]]],
  "    con las condiciones ",
  Cell[BoxData[
      \(TraditionalForm\`x(0) = 35, \ x' \((0)\) = \(-48\), \ y(0) = 27, \ 
      y' \((0)\) = \(-55. \)\)]],
  "\n\ne) Calcular las corrientes que circulan por las ramas del circuito el\
\[EAcute]ctrico de la figura siguiente suponiendo que inicialmente est\
\[AAcute] en reposo. \n"
}], "ExerciseText"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .60938 
%%ImageSize: 263.344 160.454 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.285342 0.47619 [
[.5 .59487 -11 -7 ]
[.5 .59487 11 7 ]
[.78571 .59487 -13 -7 ]
[.78571 .59487 13 7 ]
[.5 .35677 -11 -7 ]
[.5 .35677 11 7 ]
[.78571 .35677 -8 -7 ]
[.78571 .35677 8 7 ]
[.5 .11868 -11 -7 ]
[.5 .11868 11 7 ]
[.78571 .11868 -8 -7 ]
[.78571 .11868 8 7 ]
[ 0 0 0 0 ]
[ 1 .60938 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0075 moveto 0 0 lineto
-0.05 -0.0075 lineto fill
-0.05 0.0075 moveto 0 0 lineto
-0.05 -0.0075 lineto
-0.05 0.0075 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 g
.006 w
[ ] 0 setdash
.02381 .28534 m
.02381 .52344 L
.38095 .52344 L
s
.61905 .52344 m
.69048 .52344 L
s
newpath
.7381 .52344 .04762 0 365.73 arc
s
newpath
.72857 .52344 .00952 0 180 arc
s
newpath
.74762 .52344 .00952 180 360 arc
s
.78571 .52344 m
.97619 .52344 L
.97619 .04725 L
s
.02381 .28534 m
.38095 .28534 L
s
.61905 .28534 m
.7381 .28534 L
s
.88095 .28534 m
.97619 .28534 L
s
.02381 .04725 m
.38095 .04725 L
s
.61905 .04725 m
.7381 .04725 L
s
.88095 .04725 m
.97619 .04725 L
s
.02381 .04725 m
.02381 .28534 L
s
gsave
.5 .59487 -72 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.000 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(30) show
73.000 15.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(W) show
81.000 15.000 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.78571 .59487 -74 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(110) show
78.000 15.000 moveto
(V) show
85.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.5 .35677 -72 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.000 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
73.000 15.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(W) show
81.000 15.000 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.78571 .35677 -69 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
68.000 15.000 moveto
(H) show
75.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.5 .11868 -72 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.000 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(20) show
73.000 15.000 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(W) show
81.000 15.000 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.78571 .11868 -69 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4) show
68.000 15.000 moveto
(H) show
75.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.02381 .52344 m
.21429 .52344 L
s
% Start of user PostScript
0 0.5 0.4 0.5 MAarrowhead1
% End of user PostScript
.97619 .52344 m
.97619 .40439 L
s
% Start of user PostScript
2. 0.5 2. 0.25 MAarrowhead1
% End of user PostScript
.97619 .28534 m
.97619 .16629 L
s
% Start of user PostScript
2. 0 2. -0.25 MAarrowhead1
% End of user PostScript
.30952 .28534 m
.16667 .28534 L
s
% Start of user PostScript
0.6 0 0.3 0 MAarrowhead1
% End of user PostScript
.02381 .04725 m
.02381 .16629 L
s
% Start of user PostScript
0 -0.5 0 -0.25 MAarrowhead1
% End of user PostScript
.02381 .28534 m
.02381 .40439 L
s
% Start of user PostScript
0 0 0 0.25 MAarrowhead1
% End of user PostScript
.38095 .52344 m
.39583 .55618 L
s
.39583 .55618 m
.4256 .4907 L
.45536 .55618 L
.48512 .4907 L
.51488 .55618 L
.54464 .4907 L
.5744 .55618 L
.60417 .4907 L
s
.60417 .4907 m
.61905 .52344 L
s
.38095 .28534 m
.39583 .31808 L
s
.39583 .31808 m
.4256 .2526 L
.45536 .31808 L
.48512 .2526 L
.51488 .31808 L
.54464 .2526 L
.5744 .31808 L
.60417 .2526 L
s
.60417 .2526 m
.61905 .28534 L
s
.7381 .28534 m
.73839 .28725 L
.73879 .28927 L
.7397 .29287 L
.74111 .29697 L
.74269 .30048 L
.74461 .30382 L
.74697 .30701 L
.74944 .30953 L
.75189 .31139 L
.75322 .31216 L
.75468 .31284 L
.7554 .31311 L
.75609 .31333 L
.75677 .31352 L
.75739 .31365 L
.75813 .31378 L
.75855 .31383 L
.75893 .31387 L
.75963 .31391 L
.76038 .31391 L
.76077 .31389 L
.7612 .31386 L
.76165 .31382 L
.76208 .31376 L
.76283 .31363 L
.76363 .31343 L
.76523 .31291 L
.76693 .31212 L
.7685 .31118 L
.76991 .31014 L
.77244 .30776 L
.77489 .30469 L
.77688 .30144 L
.77846 .29817 L
.77992 .29431 L
.78054 .29227 L
.78111 .29005 L
.78153 .28806 L
.78184 .28624 L
.78209 .2844 L
.78227 .28267 L
.78235 .2817 L
.78241 .28067 L
.78244 .27979 L
.78246 .27884 L
.78247 .27782 L
.78246 .27726 L
.78245 .27674 L
.78241 .27575 L
Mistroke
.78235 .27482 L
.78227 .27384 L
.78217 .27281 L
.78191 .27098 L
.7816 .26927 L
.78125 .26777 L
.78027 .26464 L
.77968 .26324 L
.77898 .26184 L
.77767 .25984 L
.77688 .25893 L
.77612 .25824 L
.7754 .25771 L
.77501 .25748 L
.77459 .25727 L
.77423 .25711 L
.77382 .25698 L
.77345 .25688 L
.7731 .25682 L
.77268 .25678 L
.77224 .25677 L
.77182 .25681 L
.77144 .25687 L
.771 .25697 L
.77052 .25714 L
.77008 .25733 L
.76967 .25755 L
.76887 .25809 L
.76802 .25885 L
.76716 .25983 L
.76641 .26087 L
.76519 .26311 L
.76463 .26443 L
.76408 .26598 L
.76363 .26752 L
.76327 .26902 L
.76298 .27052 L
.76273 .27217 L
.76262 .27305 L
.76252 .27402 L
.76245 .27492 L
.76241 .27577 L
.76237 .27678 L
.76235 .27772 L
.76235 .27824 L
.76235 .27881 L
.76237 .27984 L
.76241 .28075 L
.76247 .28175 L
.76255 .2828 L
Mistroke
.76265 .28379 L
.76287 .28556 L
.76318 .28747 L
.76362 .28969 L
.76422 .29208 L
.7656 .2963 L
.76727 .30016 L
.7691 .30344 L
.77133 .30655 L
.77402 .30938 L
.77533 .31047 L
.77676 .31147 L
.77803 .3122 L
.77941 .31284 L
.78078 .31332 L
.78205 .31364 L
.78266 .31375 L
.78333 .31384 L
.78396 .31389 L
.78455 .31391 L
.78522 .31391 L
.78586 .31387 L
.78655 .3138 L
.7873 .31368 L
.78804 .31352 L
.78881 .31331 L
.79018 .31282 L
.79163 .31214 L
.79296 .31136 L
.79537 .30954 L
.79778 .30708 L
.80016 .3039 L
.80199 .30074 L
.80366 .29707 L
.80485 .29375 L
.80588 .28994 L
.80631 .28784 L
.80669 .28553 L
.80683 .28448 L
.80695 .28335 L
.80705 .2823 L
.80712 .28134 L
.80717 .28033 L
.8072 .27925 L
.80721 .2783 L
.80721 .2773 L
.80718 .27642 L
.80714 .27561 L
.80709 .27472 L
.80701 .27379 L
Mistroke
.80677 .27174 L
.8066 .27062 L
.80641 .26961 L
.80602 .26786 L
.80551 .26606 L
.80443 .26324 L
.80375 .26189 L
.80307 .26075 L
.80157 .25888 L
.80067 .25808 L
.80022 .25776 L
.79979 .2575 L
.79938 .25729 L
.79894 .2571 L
.79853 .25697 L
.79815 .25687 L
.79774 .25681 L
.79728 .25677 L
.79705 .25677 L
.79681 .25678 L
.79636 .25683 L
.79593 .25692 L
.79554 .25704 L
.7951 .25721 L
.79465 .25742 L
.79389 .25789 L
.79308 .25854 L
.79167 .26013 L
.79047 .26203 L
.78932 .26455 L
.78876 .26616 L
.78831 .26777 L
.78791 .26954 L
.7876 .27129 L
.78746 .2723 L
.78733 .27341 L
.78724 .27444 L
.78717 .2754 L
.78713 .27625 L
.7871 .27718 L
.78709 .27806 L
.78709 .27887 L
.78712 .27983 L
.78716 .28088 L
.78722 .28188 L
.7873 .28281 L
.78752 .28486 L
.78779 .28672 L
.78816 .2887 L
.78864 .29085 L
Mistroke
.78982 .29484 L
.79139 .29884 L
.79314 .30227 L
.795 .30515 L
.79746 .30812 L
.7999 .31033 L
.80131 .31135 L
.8029 .31226 L
.80443 .31295 L
.80513 .3132 L
.80587 .31342 L
.80654 .31359 L
.80728 .31373 L
.80795 .31382 L
.80857 .31388 L
.80931 .31391 L
.80999 .31391 L
.81036 .31389 L
.81076 .31386 L
.81149 .31377 L
.81213 .31366 L
.81282 .31351 L
.81421 .31309 L
.81548 .31258 L
.81665 .31199 L
.81945 .31009 L
.82185 .30784 L
.82437 .3047 L
.82648 .30124 L
.82808 .29788 L
.82954 .2939 L
.83015 .29182 L
.83071 .28954 L
.83111 .28754 L
.83146 .28534 L
.83159 .28435 L
.83171 .28329 L
.83179 .28238 L
.83186 .28139 L
.83189 .28081 L
.83192 .28028 L
.83195 .27924 L
.83196 .2783 L
.83195 .27731 L
.83193 .27647 L
.83189 .27557 L
.83183 .27473 L
.83177 .27397 L
.83157 .27216 L
.83132 .27049 L
Mistroke
.83095 .26866 L
.83054 .26703 L
.8296 .26423 L
.82837 .26166 L
.82759 .26043 L
.82683 .25945 L
.82548 .25813 L
.82467 .25757 L
.8239 .25719 L
.82348 .25703 L
.82307 .25691 L
.82271 .25684 L
.82231 .25679 L
.82188 .25677 L
.82142 .25679 L
.82103 .25685 L
.8206 .25694 L
.82018 .25707 L
.81979 .25723 L
.81892 .2577 L
.81809 .25831 L
.81724 .25913 L
.81579 .26104 L
.81463 .2632 L
.81349 .26621 L
.81297 .26811 L
.81257 .26998 L
.81228 .27169 L
.81205 .27365 L
.81196 .27466 L
.81192 .27522 L
.81189 .27576 L
.81185 .27682 L
.81184 .2778 L
.81184 .27883 L
.81185 .27941 L
.81186 .27995 L
.81191 .28094 L
.81198 .282 L
.81205 .28295 L
.81214 .28384 L
.8124 .28586 L
.81278 .28806 L
.81319 .29004 L
.81441 .29439 L
.81574 .29794 L
.81748 .30154 L
.81923 .30441 L
.82133 .30715 L
.82373 .30958 L
Mistroke
.82615 .3114 L
.82768 .31228 L
.82917 .31294 L
.83053 .31339 L
.8313 .31359 L
.83203 .31373 L
.8328 .31383 L
.83323 .31387 L
.83363 .3139 L
.83437 .31391 L
.83474 .31391 L
.83514 .31389 L
.83585 .31382 L
.8366 .31371 L
.83731 .31357 L
.83795 .31341 L
.83948 .3129 L
.84111 .31215 L
.84262 .31125 L
.84397 .31028 L
.84632 .30813 L
.84865 .30534 L
.85063 .3023 L
.85223 .29922 L
.85373 .29554 L
.85504 .29128 L
.85556 .28907 L
.85601 .28668 L
.85633 .28442 L
.85644 .28336 L
.85653 .28236 L
.8566 .28143 L
.85665 .28043 L
.85668 .27986 L
.85669 .27933 L
.8567 .27833 L
.85669 .27728 L
.85667 .27633 L
.85662 .27529 L
.85658 .27472 L
.85654 .27421 L
.85636 .27245 L
.85609 .27063 L
.85577 .26897 L
.85542 .26752 L
.85446 .26452 L
.85381 .263 L
.85315 .26171 L
.85166 .25954 L
.85075 .25859 L
Mistroke
.84989 .25788 L
.84912 .25741 L
.84868 .2572 L
.84825 .25704 L
.84781 .25691 L
.8474 .25683 L
.84695 .25678 L
.84672 .25677 L
.84647 .25677 L
.84605 .25681 L
.84566 .25687 L
.84522 .25698 L
.84481 .25712 L
.84408 .25745 L
.84331 .25794 L
.84249 .25862 L
.84163 .25953 L
.84084 .26058 L
.84004 .26189 L
.83935 .26327 L
.83878 .26465 L
.83825 .26618 L
.83782 .26766 L
.83746 .26924 L
.83713 .27102 L
.83698 .27204 L
.83686 .27299 L
.83676 .27398 L
.83669 .27491 L
.83664 .27573 L
.8366 .27661 L
.83658 .2776 L
.83658 .27851 L
.8366 .27947 L
.83663 .28052 L
.83669 .28151 L
.83675 .28244 L
.83697 .28453 L
.83725 .2865 L
.83764 .28865 L
.83816 .29094 L
.83953 .29548 L
.84113 .29939 L
.84292 .30276 L
.8451 .30596 L
.84738 .30856 L
.84961 .31051 L
.85095 .31144 L
.8524 .31227 L
.85403 .31299 L
Mistroke
.85476 .31324 L
.85555 .31347 L
.8563 .31364 L
.85699 .31376 L
.85768 .31385 L
.85834 .3139 L
.85911 .31391 L
.85981 .31389 L
.86018 .31386 L
.86059 .31382 L
.86101 .31377 L
.86141 .3137 L
.86209 .31356 L
.86282 .31338 L
.86411 .31294 L
.86563 .31227 L
.86698 .3115 L
.86979 .30937 L
.87225 .3068 L
.87431 .30402 L
.87601 .30115 L
.87764 .2977 L
.87906 .2938 L
.87966 .29173 L
.88021 .28948 L
.88095 .28534 L
Mfstroke
.38095 .04725 m
.39583 .07999 L
s
.39583 .07999 m
.4256 .01451 L
.45536 .07999 L
.48512 .01451 L
.51488 .07999 L
.54464 .01451 L
.5744 .07999 L
.60417 .01451 L
s
.60417 .01451 m
.61905 .04725 L
s
.7381 .04725 m
.73839 .04915 L
.73879 .05118 L
.7397 .05477 L
.74111 .05888 L
.74269 .06238 L
.74461 .06573 L
.74697 .06892 L
.74944 .07144 L
.75189 .07329 L
.75322 .07407 L
.75468 .07475 L
.7554 .07502 L
.75609 .07524 L
.75677 .07542 L
.75739 .07556 L
.75813 .07569 L
.75855 .07574 L
.75893 .07577 L
.75963 .07581 L
.76038 .07581 L
.76077 .0758 L
.7612 .07577 L
.76165 .07572 L
.76208 .07566 L
.76283 .07553 L
.76363 .07534 L
.76523 .07481 L
.76693 .07402 L
.7685 .07308 L
.76991 .07204 L
.77244 .06966 L
.77489 .06659 L
.77688 .06335 L
.77846 .06007 L
.77992 .05622 L
.78054 .05418 L
.78111 .05196 L
.78153 .04997 L
.78184 .04814 L
.78209 .04631 L
.78227 .04458 L
.78235 .0436 L
.78241 .04257 L
.78244 .0417 L
.78246 .04074 L
.78247 .03973 L
.78246 .03916 L
.78245 .03865 L
.78241 .03766 L
Mistroke
.78235 .03673 L
.78227 .03575 L
.78217 .03471 L
.78191 .03288 L
.7816 .03117 L
.78125 .02967 L
.78027 .02655 L
.77968 .02514 L
.77898 .02374 L
.77767 .02175 L
.77688 .02084 L
.77612 .02014 L
.7754 .01961 L
.77501 .01938 L
.77459 .01917 L
.77423 .01902 L
.77382 .01888 L
.77345 .01879 L
.7731 .01872 L
.77268 .01868 L
.77224 .01868 L
.77182 .01871 L
.77144 .01877 L
.771 .01888 L
.77052 .01904 L
.77008 .01924 L
.76967 .01946 L
.76887 .02 L
.76802 .02076 L
.76716 .02173 L
.76641 .02277 L
.76519 .02502 L
.76463 .02633 L
.76408 .02789 L
.76363 .02942 L
.76327 .03092 L
.76298 .03243 L
.76273 .03408 L
.76262 .03495 L
.76252 .03593 L
.76245 .03682 L
.76241 .03767 L
.76237 .03869 L
.76235 .03962 L
.76235 .04014 L
.76235 .04071 L
.76237 .04175 L
.76241 .04265 L
.76247 .04366 L
.76255 .04471 L
Mistroke
.76265 .0457 L
.76287 .04747 L
.76318 .04937 L
.76362 .05159 L
.76422 .05399 L
.7656 .05821 L
.76727 .06206 L
.7691 .06534 L
.77133 .06846 L
.77402 .07129 L
.77533 .07237 L
.77676 .07337 L
.77803 .0741 L
.77941 .07474 L
.78078 .07523 L
.78205 .07554 L
.78266 .07565 L
.78333 .07574 L
.78396 .07579 L
.78455 .07582 L
.78522 .07581 L
.78586 .07578 L
.78655 .0757 L
.7873 .07558 L
.78804 .07542 L
.78881 .07521 L
.79018 .07473 L
.79163 .07405 L
.79296 .07327 L
.79537 .07144 L
.79778 .06898 L
.80016 .06581 L
.80199 .06264 L
.80366 .05898 L
.80485 .05565 L
.80588 .05184 L
.80631 .04974 L
.80669 .04744 L
.80683 .04638 L
.80695 .04526 L
.80705 .04421 L
.80712 .04325 L
.80717 .04224 L
.8072 .04115 L
.80721 .0402 L
.80721 .03921 L
.80718 .03833 L
.80714 .03751 L
.80709 .03663 L
.80701 .0357 L
Mistroke
.80677 .03364 L
.8066 .03252 L
.80641 .03151 L
.80602 .02977 L
.80551 .02796 L
.80443 .02514 L
.80375 .02379 L
.80307 .02266 L
.80157 .02079 L
.80067 .01998 L
.80022 .01966 L
.79979 .0194 L
.79938 .01919 L
.79894 .019 L
.79853 .01887 L
.79815 .01878 L
.79774 .01871 L
.79728 .01868 L
.79705 .01868 L
.79681 .01869 L
.79636 .01874 L
.79593 .01883 L
.79554 .01894 L
.7951 .01911 L
.79465 .01933 L
.79389 .01979 L
.79308 .02045 L
.79167 .02203 L
.79047 .02394 L
.78932 .02646 L
.78876 .02807 L
.78831 .02967 L
.78791 .03144 L
.7876 .0332 L
.78746 .0342 L
.78733 .03531 L
.78724 .03634 L
.78717 .03731 L
.78713 .03816 L
.7871 .03908 L
.78709 .03997 L
.78709 .04078 L
.78712 .04174 L
.78716 .04279 L
.78722 .04379 L
.7873 .04472 L
.78752 .04677 L
.78779 .04862 L
.78816 .0506 L
.78864 .05275 L
Mistroke
.78982 .05675 L
.79139 .06075 L
.79314 .06417 L
.795 .06706 L
.79746 .07002 L
.7999 .07224 L
.80131 .07325 L
.8029 .07417 L
.80443 .07485 L
.80513 .0751 L
.80587 .07532 L
.80654 .07549 L
.80728 .07563 L
.80795 .07573 L
.80857 .07579 L
.80931 .07582 L
.80999 .07581 L
.81036 .07579 L
.81076 .07576 L
.81149 .07568 L
.81213 .07557 L
.81282 .07542 L
.81421 .075 L
.81548 .07449 L
.81665 .0739 L
.81945 .072 L
.82185 .06975 L
.82437 .0666 L
.82648 .06314 L
.82808 .05978 L
.82954 .0558 L
.83015 .05373 L
.83071 .05144 L
.83111 .04945 L
.83146 .04725 L
.83159 .04626 L
.83171 .0452 L
.83179 .04428 L
.83186 .0433 L
.83189 .04272 L
.83192 .04219 L
.83195 .04114 L
.83196 .0402 L
.83195 .03922 L
.83193 .03837 L
.83189 .03747 L
.83183 .03663 L
.83177 .03587 L
.83157 .03406 L
.83132 .0324 L
Mistroke
.83095 .03057 L
.83054 .02893 L
.8296 .02614 L
.82837 .02357 L
.82759 .02233 L
.82683 .02135 L
.82548 .02003 L
.82467 .01948 L
.8239 .01909 L
.82348 .01893 L
.82307 .01882 L
.82271 .01874 L
.82231 .01869 L
.82188 .01868 L
.82142 .0187 L
.82103 .01875 L
.8206 .01885 L
.82018 .01898 L
.81979 .01914 L
.81892 .01961 L
.81809 .02022 L
.81724 .02104 L
.81579 .02294 L
.81463 .02511 L
.81349 .02812 L
.81297 .03002 L
.81257 .03188 L
.81228 .03359 L
.81205 .03555 L
.81196 .03656 L
.81192 .03713 L
.81189 .03767 L
.81185 .03873 L
.81184 .0397 L
.81184 .04073 L
.81185 .04131 L
.81186 .04185 L
.81191 .04285 L
.81198 .0439 L
.81205 .04485 L
.81214 .04574 L
.8124 .04777 L
.81278 .04996 L
.81319 .05194 L
.81441 .05629 L
.81574 .05985 L
.81748 .06345 L
.81923 .06632 L
.82133 .06906 L
.82373 .07149 L
Mistroke
.82615 .07331 L
.82768 .07418 L
.82917 .07485 L
.83053 .0753 L
.8313 .07549 L
.83203 .07563 L
.8328 .07574 L
.83323 .07578 L
.83363 .0758 L
.83437 .07582 L
.83474 .07581 L
.83514 .07579 L
.83585 .07573 L
.8366 .07562 L
.83731 .07548 L
.83795 .07531 L
.83948 .0748 L
.84111 .07405 L
.84262 .07316 L
.84397 .07218 L
.84632 .07004 L
.84865 .06724 L
.85063 .0642 L
.85223 .06112 L
.85373 .05744 L
.85504 .05318 L
.85556 .05097 L
.85601 .04858 L
.85633 .04632 L
.85644 .04526 L
.85653 .04427 L
.8566 .04333 L
.85665 .04233 L
.85668 .04177 L
.85669 .04123 L
.8567 .04023 L
.85669 .03919 L
.85667 .03823 L
.85662 .0372 L
.85658 .03663 L
.85654 .03611 L
.85636 .03436 L
.85609 .03253 L
.85577 .03088 L
.85542 .02943 L
.85446 .02642 L
.85381 .0249 L
.85315 .02362 L
.85166 .02145 L
.85075 .02049 L
Mistroke
.84989 .01979 L
.84912 .01932 L
.84868 .0191 L
.84825 .01894 L
.84781 .01882 L
.8474 .01873 L
.84695 .01869 L
.84672 .01868 L
.84647 .01868 L
.84605 .01871 L
.84566 .01877 L
.84522 .01888 L
.84481 .01902 L
.84408 .01936 L
.84331 .01984 L
.84249 .02052 L
.84163 .02143 L
.84084 .02249 L
.84004 .02379 L
.83935 .02517 L
.83878 .02655 L
.83825 .02809 L
.83782 .02957 L
.83746 .03114 L
.83713 .03293 L
.83698 .03394 L
.83686 .0349 L
.83676 .03588 L
.83669 .03682 L
.83664 .03763 L
.8366 .03852 L
.83658 .03951 L
.83658 .04042 L
.8366 .04138 L
.83663 .04242 L
.83669 .04342 L
.83675 .04434 L
.83697 .04644 L
.83725 .0484 L
.83764 .05055 L
.83816 .05284 L
.83953 .05738 L
.84113 .0613 L
.84292 .06466 L
.8451 .06787 L
.84738 .07046 L
.84961 .07241 L
.85095 .07334 L
.8524 .07417 L
.85403 .07489 L
Mistroke
.85476 .07515 L
.85555 .07537 L
.8563 .07555 L
.85699 .07567 L
.85768 .07575 L
.85834 .0758 L
.85911 .07582 L
.85981 .07579 L
.86018 .07577 L
.86059 .07573 L
.86101 .07567 L
.86141 .07561 L
.86209 .07547 L
.86282 .07528 L
.86411 .07485 L
.86563 .07417 L
.86698 .07341 L
.86979 .07127 L
.87225 .06871 L
.87431 .06593 L
.87601 .06305 L
.87764 .05961 L
.87906 .0557 L
.87966 .05364 L
.88021 .05138 L
.88095 .04725 L
Mfstroke
0 0 m
1 0 L
1 .60938 L
0 .60938 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.313, 160.438},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006:0000l2000`400?l00000o`00003oo`3ooon;
0?ooo`00o`3ooon;0?ooo`00o`3ooon;0?ooo`00o`3ooon;0?ooo`00Z03oool00`000000oooo0?oo
o`0D0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0503oool00`000000oooo0?oo
o`2J0?ooo`00Z03oool2000001D0oooo0P00000E0?ooo`800000503oool3000009/0oooo002W0?oo
o`<00000503oool3000001@0oooo0`00000D0?ooo`<00000V`3oool00:L0oooo1000000C0?ooo`@0
00004`3oool4000001<0oooo0`00000l0?ooo`D000001@3oool4000000D0oooo1@0000050?ooo`D0
0000?@3oool00:H0oooo0P0000000`3oool000000000000B0?ooo`80000000<0oooo000000000000
4P3oool2000000030?ooo`00000000000180oooo1@00000j0?ooo`L000000`3oool6000000@0oooo
1P0000030?ooo`L00000?03oool00:H0oooo00<000000?ooo`3oool00P00000B0?ooo`030000003o
ool0oooo008000004P3oool00`000000oooo0?ooo`0200000180oooo00<000000?ooo`3oool00P00
000j0?ooo`<000000P3oool200000080oooo0`0000000`3oool000000000000200000080oooo0`00
0000103oool000000000000000020?ooo`@0000000@0oooo0000000000000000?03oool00:D0oooo
0P0000020?ooo`<00000403oool200000080oooo0`00000@0?ooo`8000000P3oool300000100oooo
0P0000020?ooo`<00000>03oool3000000<0oooo0`0000000`3oool00000000000040?ooo`800000
0P3oool2000000<0oooo0`000000103oool000000000000000020?ooo`<00000?03oool00:D0oooo
00<000000?ooo`3oool00P3oool200000100oooo00<000000?ooo`3oool00P3oool200000100oooo
00<000000?ooo`3oool00P3oool200000100oooo00<000000?ooo`3oool00P3oool2000003P0oooo
0`0000040?ooo`80000000<0oooo000000000000103oool2000000040?ooo`0000000000000000@0
oooo0P0000000`3oool00000000000040?ooo`<00000>`3oool00:D0oooo00<000000?ooo`3oool0
0P3oool3000000l0oooo00<000000?ooo`3oool00P3oool3000000l0oooo00<000000?ooo`3oool0
0P3oool3000000l0oooo00<000000?ooo`3oool00P3oool2000003P0oooo0P0000050?ooo`D00000
103oool5000000D0oooo1@0000050?ooo`800000>`3oool00:@0oooo0P0000050?ooo`8000003P3o
ool2000000D0oooo0P00000>0?ooo`8000001@3oool2000000h0oooo0P0000040?ooo`<00000=`3o
ool2000000D0oooo100000050?ooo`D000001@3oool4000000H0oooo0P00000k0?ooo`00Y03oool0
0`000000oooo0?ooo`040?ooo`<000003@3oool00`000000oooo0?ooo`040?ooo`<000003@3oool0
0`000000oooo0?ooo`040?ooo`<000003@3oool00`000000oooo0?ooo`040?ooo`800000=`3oool2
000000D0oooo100000060?ooo`@000001@3oool4000000H0oooo0P00000k0?ooo`00X`3oool20000
00L0oooo0P00000<0?ooo`8000001`3oool2000000`0oooo0P0000070?ooo`800000303oool20000
00H0oooo0`00000f0?ooo`8000001@3oool4000000H0oooo100000050?ooo`@000001P3oool20000
03/0oooo002S0?ooo`030000003oool0oooo00H0oooo0P00000<0?ooo`030000003oool0oooo00H0
oooo0P00000<0?ooo`030000003oool0oooo00H0oooo0P00000<0?ooo`030000003oool0oooo00H0
oooo0P00000f0?ooo`8000001@3oool4000000H0oooo100000050?ooo`@000001P3oool2000003/0
oooo002G0?ooo`030000003oool0oooo00P0oooo0P0000080?ooo`<000002P3oool2000000P0oooo
0`00000:0?ooo`800000203oool3000000X0oooo0P0000080?ooo`800000=P3oool2000000D0oooo
100000060?ooo`@000001@3oool4000000H0oooo0P00000k0?ooo`00303ooon=000000T0oooo00<0
00000?ooo`3oool0203oool2000000X0oooo00<000000?ooo`3oool0203oool2000000X0oooo00<0
00000?ooo`3oool0203oool2000000X0oooo00<000000?ooo`3oool01`3oool`000000P0oooo0P00
00050?ooo`@000001P3oool4000000D0oooo100000060?ooo`8000001`3ooolW000000d0oooo000<
0?ooohd00000203oool2000000X0oooo0`0000080?ooo`8000002P3oool3000000P0oooo0P00000:
0?ooo`<00000203oool2000000T0oooo<00000080?ooo`8000001@3oool5000000@0oooo1@000005
0?ooo`D000001@3oool2000000L0oooo9`00000=0?ooo`00303oool2000008T0oooo0P0000080?oo
o`030000003oool0oooo00X0oooo0P0000080?ooo`030000003oool0oooo00X0oooo0P0000080?oo
o`030000003oool0oooo00X0oooo0P0000080?ooo`030000003oool0oooo03H0oooo0`0000070?oo
o`8000001@3oool2000000040?ooo`0000000000000000<0oooo0P0000020?ooo`030000003oool0
oooo00<0oooo1@0000040?ooo`<000001`3oool2000002<0oooo0P00000=0?ooo`00303oool20000
08T0oooo0`0000060?ooo`800000303oool2000000L0oooo0P00000<0?ooo`8000001`3oool20000
00`0oooo0P0000070?ooo`800000>@3oool2000000L0oooo0`0000040?ooo`80000000<0oooo0000
00000000103oool200000080oooo0P0000030?ooo`<0000000<0oooo000000000000103oool20000
00L0oooo0`00000S0?ooo`8000003@3oool000`0oooo0P00002:0?ooo`8000001P3oool00`000000
oooo0?ooo`0;0?ooo`<000001P3oool00`000000oooo0?ooo`0;0?ooo`<000001P3oool00`000000
oooo0?ooo`0;0?ooo`<000001P3oool00`000000oooo0?ooo`0h0?ooo`800000203oool2000000<0
oooo0`000000103oool000000000000000030?ooo`8000000`3oool010000000oooo0?ooo`3oool3
000000040?ooo`0000000000000000<0oooo0P0000070?ooo`<000008`3oool2000000d0oooo000<
0?ooo`800000RP3oool3000000@0oooo0P00000>0?ooo`8000001@3oool2000000h0oooo0P000005
0?ooo`8000003P3oool2000000D0oooo0P00000j0?ooo`<000001`3oool2000000<0oooo0P000003
0?ooo`8000000`3oool010000000oooo0?ooo`3oool300000080oooo0P0000030?ooo`8000000P3o
ool3000000L0oooo0P00000T0?ooo`8000003@3oool000`0oooo0P00002;0?ooo`800000103oool0
0`000000oooo0?ooo`0=0?ooo`<00000103oool00`000000oooo0?ooo`0=0?ooo`<00000103oool0
0`000000oooo0?ooo`0=0?ooo`<00000103oool00`000000oooo0?ooo`0j0?ooo`<000001P3oool3
00000080oooo0P0000030?ooo`8000000P3oool2000000@0oooo0P0000020?ooo`800000103oool2
000000030?ooo`000000000000L0oooo0`00000T0?ooo`8000003@3oool000`0oooo0P00002;0?oo
o`800000103oool00`000000oooo0?ooo`0>0?ooo`800000103oool00`000000oooo0?ooo`0>0?oo
o`800000103oool00`000000oooo0?ooo`0>0?ooo`800000103oool00`000000oooo0?ooo`0k0?oo
o`<000001P3oool5000000@0oooo1P0000040?ooo`D000001P3oool010000000oooo000000000007
0?ooo`8000009@3oool2000000d0oooo000<0?ooo`800000R`3oool300000080oooo0P00000@0?oo
o`<000000P3oool200000100oooo0`0000020?ooo`800000403oool300000080oooo0P00000n0?oo
o`<000001P3oool3000000H0oooo100000060?ooo`<000001P3oool5000000H0oooo0`00000U0?oo
o`8000003@3oool000`0oooo0P00002<0?ooo`8000000P3oool00`000000oooo0?ooo`0@0?ooo`80
00000P3oool00`000000oooo0?ooo`0@0?ooo`8000000P3oool00`000000oooo0?ooo`0@0?ooo`80
00000P3oool00`000000oooo0?ooo`0n0?ooo`8000001P3oool4000000D0oooo100000060?ooo`@0
00001P3oool3000000H0oooo0`00000V0?ooo`8000003@3oool000`0oooo0P00002<0?ooo`D00000
4P3oool2000000030?ooo`00000000000180oooo0P0000000`3oool000000000000B0?ooo`800000
00<0oooo000000000000@03oool400000080oooo1`0000030?ooo`L000000P3oool7000000<0oooo
1`0000020?ooo`@000009`3oool2000000d0oooo000<0?ooo`800000S@3oool3000001<0oooo1000
000C0?ooo`@000004`3oool400000440oooo2@0000020?ooo`L000000P3oool9000000030?ooo`00
0000000000H0000000<0oooo0000000000001P00000X0?ooo`8000003@3oool000`0oooo0P00002=
0?ooo`<00000503oool3000001@0oooo0`00000D0?ooo`<00000A03oool5000000<0oooo1P000005
0?ooo`D000000`3oool6000000@0oooo1P00000Y0?ooo`8000003@3oool000`0oooo0P00002=0?oo
o`<00000503oool2000001D0oooo0P00000E0?ooo`800000V@3oool2000000d0oooo000<0?ooo`80
0000SP3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3o
ool0503oool00`000000oooo0?ooo`2G0?ooo`8000003@3oool000`0oooo0P00003o0?ooofh0oooo
0P00000=0?ooo`00303oool200000?l0ooooKP3oool2000000d0oooo000<0?ooo`800000o`3ooom^
0?ooo`8000003@3oool000`0oooo0P00003o0?ooofh0oooo0P00000=0?ooo`00303oool200000?l0
ooooKP3oool2000000d0oooo000<0?ooo`800000o`3ooom^0?ooo`8000003@3oool000`0oooo0P00
003o0?ooofh0oooo0P00000=0?ooo`00303oool200000?l0ooooKP3oool2000000d0oooo000<0?oo
o`800000Z@3oool00`3DV`00000000000002000000080000V`3Dool0oooo0?oojP2jLP000000001b
^P3Zool20?ooo`080>ZjLP00000000000000001b^^X0oooo0?oZ^P1b00020000000307:jjP3oool0
oooo05X0oooo00D0oooZ0;Yb002Ke?l0oooZ0;Yb00030000000309_Do`3oool0j[Yb00<0000000<0
09_D0?ooo`3oool0?@3oool2000000d0oooo000<0?ooo`800000ZP3oool0303Z^W80VmCo0?ooo`3o
ool0omBK09_Do`3oool0e9/007:jjP3oool0j[Yb002Ke080oooo00D0e9^K0=Coo`3oonX0^Y^j0>[o
o`020?ooo`040>ZjV`2jj_l0oooD09^Ke5`0oooo00<0oooZ0;Yb002Ke?l00P3oool00`3oe9/0002K
0=Coo`030?ooo`030?oZ^P1b0780^^[o0400oooo0P00000=0?ooo`00303oool200000:/0oooo00<0
e9]b0;[Zo`3oool00P3oool01`3oj[X0LP2K0=Coo`3oool0oooD09/0LP2jj_l00`3oool00`3DV`00
L[[Z0?ooo`020?ooo`030?oZ^P1bL[X0j_oo05d0oooo00<0oooZ0;Yb002Ke?l00P3oool00`3oe9/0
07:j0>[oo`030?ooo`030?ooe02K0780^^[o0400oooo0P00000=0?ooo`00303oool200000:/0oooo
00<0oooZ0;YbV`3Dool00P3oool01`3oe9/007:j0>[oo`3oool0oooZ0;Yb002Ke?l00P3oool00`3o
j[X0LP1b0;[Zo`030?ooo`030?ooe02K0000L[[Z05X0oooo00<0e9/00000000000000`0000001@1b
^^X0oooo0?oDV`00L[X0j_oo00<0oooo00<0oooD09/0LP2jj_l0@03oool2000000d0oooo000:0?oo
o`L00000Z@3oool02`3oj[X0LY_D0?ooo`3oool0j[Yb001b^P3Zool0oooo0?oojP2jLP00L[[Z0080
oooo00<0j[Yb0000V`3Dool00`3oool0103oonX0^W80001b^P3ZoomI0?ooo`060?oDV`2Ke?l0oooo
0?oojP2jLP00VmCo0P3oool00`3oe9/007:j0>[oo`030?ooo`030?ooe02K0780^^[o0400oooo0P00
000=0?ooo`002P3oool700000:X0oooo00X0e9/009_Do`3oool0j[Yb001b^P3Zool0oooo0?oojP2j
LP00L[[Z0P3oool00`3DV`00002K0=Coo`040?ooo`030=BK000009/0e?oo05X0oooo00D0e9]b0;[Z
o`3oonX0^W8009_Do`020?ooo`030?oDV`000000000000@0000000<0001b0;[Zo`3oool0?`3oool2
000000d0oooo000:0?ooo`L00000ZP3oool02P3oe9/009_D0?ooo`3oe9/007:j0>[oo`3oool0oooZ
0;Yb002Ke?l20?ooo`030=BK000009/0e?oo00@0oooo00<0e9/0001b^P3Zool0FP3oool01@3oonX0
^Y^j0>[ojP2jLP00VmCo0080oooo00<0omBK001b^P3Zool00`3oool00`3oom@0V`1b0;[Zo`100?oo
o`8000003@3oool000X0oooo1`00002V0?ooo`0>0>[De03Zool0oooo0?ooo`3Z^W8007:j0>[oo`3o
om@0V`1b0;[Zo`3oool0oooD09/0LP2jj_l20?ooo`030?oDV`000000VmCo00<0oooo00<0oooD09/0
001b^^X0G03oool0103oj[X0Vk[D0;Yb002Ke?l20?ooo`030?oDV`00L[X0j_oo00<0oooo00<0oooD
09/0LP2jj_l0@03oool2000000d0oooo000;0?ooo`D00000Y`3oool01P3oj[X0LY_D0?ooo`3oom@0
V`00002Ke080oooo00D0e9/007:jjP3oool0j[Yb002Ke0040?ooo`030=BK000009/0e?oo0080oooo
00<0e9/00000V`3Dool0G@3oool00`3Z^W80000009_Do`020?ooo`030?oDV`0009/0e?oo00<0oooo
00<0oooD09/0LP2jj_l0@03oool2000000d0oooo000;0?ooo`D00000Z03oool01@3oe9/000000000
0000L[X0j_oo0080oooo00D0oooZ0;Yb0000000007:j0>[oo`050?ooo`060?oDV`00000000000000
0000L[X0j_ooGP3oool01@3oonX0^W8009_Do`3oonX0^W8000<0000000<0VmCo0?ooo`3Z^W800`00
00000`00Vm@0oooo0?ooo`0m0?ooo`8000003@3oool000/0oooo1@00003o0?ooof`0oooo0P00000=
0?ooo`002`3oool500000?l0ooooK03oool2000000d0oooo000;0?ooo`D00000o`3ooom/0?ooo`80
00003@3oool000/0oooo1@00003o0?ooof`0oooo0P00000=0?ooo`00303oool300000?l0ooooK@3o
ool2000000d0oooo000<0?ooo`<00000o`3ooom]0?ooo`8000003@3oool000`0oooo0`00003o0?oo
ofd0oooo0P00000=0?ooo`00303oool300000?l0ooooK@3oool2000000d0oooo000<0?ooo`<00000
o`3ooom]0?ooo`8000003@3oool000`0oooo0`00003o0?ooofd0oooo0P00000=0?ooo`00303oool2
00000?l0ooooKP3oool2000000d0oooo000<0?ooo`800000o`3ooom^0?ooo`8000003@3oool000`0
oooo0P00003o0?ooofh0oooo0P00000=0?ooo`00303oool200000?l0ooooKP3oool2000000d0oooo
000<0?ooo`800000o`3ooom^0?ooo`8000003@3oool000`0oooo0P00003o0?ooofh0oooo0P00000=
0?ooo`00303oool200000?l0ooooKP3oool2000000d0oooo000<0?ooo`800000o`3ooom^0?ooo`<0
0000303oool000`0oooo0P00003o0?ooofh0oooo0`00000<0?ooo`00303oool200000?l0ooooKP3o
ool3000000`0oooo000<0?ooo`800000o`3ooom^0?ooo`<00000303oool000`0oooo0P00003o0?oo
ofh0oooo0`00000<0?ooo`00303oool200000?l0ooooKP3oool3000000`0oooo000<0?ooo`800000
o`3ooom]0?ooo`D000002`3oool000`0oooo0P00003o0?ooofd0oooo1@00000;0?ooo`00303oool2
00000?l0ooooK@3oool5000000/0oooo000<0?ooo`800000o`3ooom]0?ooo`D000002`3oool000`0
oooo0P00003o0?ooofd0oooo1@00000;0?ooo`00303oool200000?l0ooooK@3oool5000000/0oooo
000<0?ooo`800000o`3ooom/0?ooo`L000002P3oool000`0oooo0P00003o0?ooof`0oooo1`00000:
0?ooo`00303oool200000?l0ooooK03oool7000000X0oooo000<0?ooo`800000o`3ooom/0?ooo`L0
00002P3oool000`0oooo0P00003o0?ooofh0oooo0P00000=0?ooo`00303oool200000?l0ooooKP3o
ool2000000d0oooo000<0?ooo`800000o`3ooom^0?ooo`8000003@3oool000`0oooo0P00003o0?oo
ofh0oooo0P00000=0?ooo`00303oool200000?l0ooooKP3oool2000000d0oooo000<0?ooo`800000
o`3ooom^0?ooo`8000003@3oool000`0oooo0P00003o0?ooofh0oooo0P00000=0?ooo`00303oool2
00000?l0ooooKP3oool2000000d0oooo000<0?ooo`800000o`3ooom^0?ooo`8000003@3oool000`0
oooo0P00003o0?ooofh0oooo0P00000=0?ooo`00303oool200000?l0ooooKP3oool2000000d0oooo
000<0?ooo`800000o`3ooom^0?ooo`8000003@3oool000`0oooo0P00002J0?ooo`030000003oool0
oooo01@0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0D0?ooo`030000003oool0
oooo08/0oooo0P00000=0?ooo`00303oool2000009X0oooo00<000000?ooo`3oool0503oool00`00
0000oooo0?ooo`0D0?ooo`030000003oool0oooo01<0oooo0`00002<0?ooo`8000003@3oool000`0
oooo0P00002I0?ooo`<00000503oool3000001@0oooo0`00000D0?ooo`<00000S03oool2000000d0
oooo000<0?ooo`800000V@3oool00`000000oooo0000000D0?ooo`030000003oool0000001@0oooo
00<000000?ooo`000000503oool3000003`0oooo1@0000040?ooo`H00000103oool5000000@0oooo
1P00000^0?ooo`8000003@3oool000`0oooo0P00002H0?ooo`80000000<0oooo0000000000004P3o
ool2000000030?ooo`00000000000180oooo0P0000000`3oool000000000000B0?ooo`D00000>P3o
ool7000000<0oooo1P0000030?ooo`L000000`3oool6000002h0oooo0P00000=0?ooo`00303oool2
000009P0oooo00D000000?ooo`3oool0oooo0000000B0?ooo`050000003oool0oooo0?ooo`000000
4P3oool01@000000oooo0?ooo`3oool000000180oooo00<000000?ooo`3oool00P00000j0?ooo`<0
00000P3oool200000080oooo0`0000020?ooo`<000000P3oool3000000040?ooo`00000000000000
0080oooo0`0000020?ooo`<00000;@3oool2000000d0oooo000<0?ooo`800000U`3oool2000000<0
oooo00<000000?ooo`3oool03`3oool2000000<0oooo00<000000?ooo`3oool03`3oool2000000<0
oooo00<000000?ooo`3oool03`3oool200000080oooo0`00000h0?ooo`<000000`3oool300000003
0?ooo`000000000000<0oooo0`000000103oool000000000000000030?ooo`<0000000<0oooo0000
000000000`3oool3000002d0oooo0P00000=0?ooo`00303oool2000009L0oooo00<000000?ooo`3o
ool00P3oool200000100oooo00<000000?ooo`3oool00P3oool200000100oooo00<000000?ooo`3o
ool00P3oool200000100oooo00<000000?ooo`3oool00P3oool2000003P0oooo0P0000050?ooo`80
000000<0oooo000000000000103oool2000000030?ooo`000000000000D0oooo0P0000000`3oool0
0000000000040?ooo`<00000;03oool2000000d0oooo000<0?ooo`800000UP3oool2000000D0oooo
00<000000?ooo`3oool03@3oool2000000D0oooo00<000000?ooo`3oool03@3oool2000000D0oooo
00<000000?ooo`3oool03@3oool2000000@0oooo0P00000h0?ooo`8000001@3oool5000000@0oooo
1@0000050?ooo`D00000103oool3000002`0oooo0P00000=0?ooo`00303oool2000009H0oooo00<0
00000?ooo`3oool0103oool2000000h0oooo00<000000?ooo`3oool0103oool2000000h0oooo00<0
00000?ooo`3oool0103oool2000000h0oooo00<000000?ooo`3oool00`3oool3000003L0oooo0P00
00050?ooo`@000001@3oool5000000D0oooo100000060?ooo`800000;03oool2000000d0oooo000<
0?ooo`800000U@3oool2000000L0oooo00<000000?ooo`3oool02`3oool2000000L0oooo00<00000
0?ooo`3oool02`3oool2000000L0oooo00<000000?ooo`3oool02`3oool2000000H0oooo0P00000g
0?ooo`8000001@3oool4000000H0oooo100000050?ooo`@000001P3oool2000002`0oooo0P00000=
0?ooo`00303oool2000004<0oooo1`00001;0?ooo`030000003oool0oooo00H0oooo0P00000<0?oo
o`030000003oool0oooo00H0oooo0P00000<0?ooo`030000003oool0oooo00H0oooo0P00000<0?oo
o`030000003oool0oooo00D0oooo0`00000f0?ooo`8000001@3oool4000000H0oooo100000050?oo
o`@000001P3oool2000002`0oooo0P00000=0?ooo`00303oool2000003d0oooo3@00001:0?ooo`80
00002@3oool00`000000oooo0?ooo`090?ooo`8000002@3oool00`000000oooo0?ooo`090?ooo`80
00002@3oool00`000000oooo0?ooo`090?ooo`800000203oool2000003H0oooo0P0000050?ooo`@0
00001P3oool4000000D0oooo100000060?ooo`800000;03oool2000000d0oooo000<0?ooo`800000
=P3ooolD000003l0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`070?ooo`800000
=P3oool2000000D0oooo100000060?ooo`@000001@3oool4000000H0oooo0P00000/0?ooo`800000
3@3oool000`0ooooS@0000090?ooo`030000003oool0oooo00P0oooo0P00000:0?ooo`030000003o
ool0oooo00P0oooo0P00000:0?ooo`030000003oool0oooo00P0oooo0P00000:0?ooo`030000003o
ool0oooo00L0oooo<00000080?ooo`8000001@3oool4000000H0oooo100000050?ooo`D000001@3o
ool2000000L0oooo9`00000=0?ooo`00303ooon=000000P0oooo0P00000;0?ooo`030000003oool0
oooo00L0oooo0P00000;0?ooo`030000003oool0oooo00L0oooo0P00000;0?ooo`030000003oool0
oooo00L0oooo0P0000090?oooc000000203oool2000000D0oooo1@0000040?ooo`D000001@3oool2
000000030?ooo`000000000000@0oooo0`0000070?ooobL000003@3oool000`0oooo0P00000m0?oo
o`d00000?`3oool3000000L0oooo00<000000?ooo`3oool02P3oool2000000P0oooo00<000000?oo
o`3oool02P3oool2000000P0oooo00<000000?ooo`3oool02P3oool2000000P0oooo00<000000?oo
o`3oool0=`3oool2000000P0oooo00<000000?ooo`3oool00`3oool2000000040?ooo`0000000000
000000<0oooo0P000000103oool000000000000000040?ooo`80000000<0oooo000000000000103o
ool2000000P0oooo0P00000S0?ooo`8000003@3oool000`0oooo0P0000130?ooo`L00000@03oool2
000000H0oooo0P00000=0?ooo`030000003oool0oooo00D0oooo0P00000=0?ooo`030000003oool0
oooo00D0oooo0P00000=0?ooo`030000003oool0oooo00D0oooo0P00000j0?ooo`030000003oool0
oooo00H0oooo0P0000030?ooo`<000000P3oool00`000000oooo0?ooo`020?ooo`8000000P3oool2
000000<0oooo0`0000000`3oool00000000000040?ooo`8000001`3oool3000002<0oooo0P00000=
0?ooo`00303oool2000004T0oooo00<000000?ooo`3oool0?P3oool2000000H0oooo00<000000?oo
o`3oool0303oool2000000H0oooo00<000000?ooo`3oool0303oool2000000H0oooo00<000000?oo
o`3oool0303oool2000000H0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`070?oo
o`040000003oool0oooo0?ooo`8000000`3oool200000080oooo0`0000020?ooo`8000000`3oool2
00000080oooo0`0000030?ooo`8000001`3oool2000002@0oooo0P00000=0?ooo`00303oool20000
08X0oooo0`0000040?ooo`8000003`3oool00`000000oooo0?ooo`030?ooo`8000003`3oool00`00
0000oooo0?ooo`030?ooo`8000003`3oool00`000000oooo0?ooo`030?ooo`800000>`3oool20000
00P0oooo00@000000?ooo`3oool0oooo0P0000040?ooo`030000003oool0oooo008000000`3oool3
00000080oooo0P0000030?ooo`<0000000@0oooo00000000000000001`3oool2000002@0oooo0P00
000=0?ooo`00303oool2000008/0oooo0P0000040?ooo`030000003oool0oooo00h0oooo0P000004
0?ooo`030000003oool0oooo00h0oooo0P0000040?ooo`030000003oool0oooo00h0oooo0P000004
0?ooo`030000003oool0oooo03/0oooo0P0000070?ooo`80000000@0oooo00000000000000000`3o
ool3000000030?ooo`000000000000@0oooo0P000000103oool000000000000000040?ooo`800000
00<0oooo0000000000001`3oool3000002@0oooo0P00000=0?ooo`00303oool2000008/0oooo0`00
00020?ooo`8000004@3oool010000000oooo0?ooo`3oool200000140oooo00@000000?ooo`3oool0
oooo0P00000A0?ooo`040000003oool0oooo0?ooo`800000?@3oool3000000L0oooo100000050?oo
o`D00000103oool5000000D0oooo0P0000000`3oool00000000000070?ooo`8000009@3oool20000
00d0oooo000<0?ooo`800000S03oool200000080oooo00<000000?ooo`3oool0403oool01@000000
oooo0?ooo`3oool000000180oooo00D000000?ooo`3oool0oooo0000000B0?ooo`050000003oool0
oooo0?ooo`000000?`3oool3000000H0oooo0`0000070?ooo`<000001P3oool3000000H0oooo1000
00070?ooo`<000009@3oool2000000d0oooo000<0?ooo`800000S03oool2000000030?ooo`000000
00000180oooo0P0000000`3oool000000000000B0?ooo`80000000<0oooo0000000000004P3oool2
000000030?ooo`00000000000400oooo0P0000050?ooo`D000001@3oool5000000@0oooo1@000005
0?ooo`D000001@3oool3000002H0oooo0P00000=0?ooo`00303oool2000008`0oooo1000000D0?oo
o`030000003oool0000001@0oooo00<000000?ooo`000000503oool00`000000oooo000000110?oo
o`@000000P3oool3000000030?ooo`00000000000080000000<0oooo0000000000001P0000000`3o
ool0000000000007000000030?ooo`000000000000H000000P3oool4000002L0oooo0P00000=0?oo
o`00303oool2000008d0oooo0`00000D0?ooo`<00000503oool3000001@0oooo0`0000110?ooo`T0
000000<0oooo0000000000001P0000030?ooo`H000000`3oool7000000<0oooo1`00000X0?ooo`80
00003@3oool000`0oooo0P00002=0?ooo`<000005@3oool00`000000oooo0?ooo`0D0?ooo`030000
003oool0oooo01@0oooo00<000000?ooo`3oool0@P3oool5000000H0oooo100000040?ooo`D00000
1P3oool4000000@0oooo1@00000Z0?ooo`8000003@3oool000`0oooo0P00002>0?ooo`030000003o
ool0oooo01@0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0D0?ooo`030000003o
ool0oooo09L0oooo0P00000=0?ooo`00303oool200000?l0ooooKP3oool2000000d0oooo000<0?oo
o`800000o`3ooom^0?ooo`8000003@3oool000`0oooo0P00003o0?ooofh0oooo0P00000=0?ooo`00
303oool200000?l0ooooKP3oool2000000d0oooo000<0?ooo`800000o`3ooom^0?ooo`8000003@3o
ool000`0oooo0P00003o0?ooofh0oooo0P00000=0?ooo`00303oool200000?l0ooooKP3oool20000
00d0oooo000<0?ooo`800000o`3ooom^0?ooo`8000003@3oool000`0oooo0P00002Z0?ooo`050?oZ
^P1b000000000000002Ke?l00P3oool01@3oonX0^W8000000000L[X0j_oo0080oooo00P0j[Yb0000
00000000000007:jjP3oool0onZj07800080000000<0L[[Z0?ooo`3oool0E`3oool00`3DV`000000
00000002000000030000V`3DonX0^W8000<0000000<0VmCo0?ooo`3Z^W800`0000000`00Vm@0oooo
0?ooo`0m0?ooo`8000003@3oool000`0oooo0P00002[0?ooo`030?ooe02K0780^^[o00<0oooo00D0
e9/007:jjP3oool0j[Yb002Ke0020?ooo`050=BKV`3Dool0oooZ0;ZK^P3Zool00P3oool0103Z^Y/0
^^[o0?ooe02KVmAJ0?ooo`0:0>ZjLP2Ke?l0oooo0?ooo`3oe9/0VmCo0?ooo`3oe9/0002K0=Coo`<0
oooo00<0onZj0780LP2jj_l0@03oool2000000d0oooo000<0?ooo`800000Z`3oool00`3oom@0V`1b
0;[Zo`020?ooo`070?oZ^P1b09/0e?oo0?ooo`3oom@0V`1b0;[Zo`030?ooo`030=BK001b^^X0oooo
0080oooo00<0onZj079b^P3Zool0G03oool00`3DVg80^^[o0?ooo`030?ooo`030?oDV`00L[X0j_oo
00<0oooo00<0oooD09/0LP2jj_l0@03oool2000000d0oooo000<0?ooo`800000Z`3oool00`3oom@0
V`1b0;[Zo`020?ooo`070?oDV`00L[X0j_oo0?ooo`3oonX0^W8009_Do`020?ooo`030?oZ^P1b0780
^^[o00<0oooo00<0oooD09/0001b^^X0G03oool00`3oonX0^W:K0=Coo`030?ooo`030?oDV`00L[X0
j_oo00<0oooo00<0oooD09/0LP2jj_l0@03oool2000000d0oooo000:0?ooo`L00000Z03oool00`3o
om@0V`1b0;[Zo`020?ooo`070>ZjLP00L[X0j_oo0?ooo`3oonX0^W8007:jjP020?ooo`030>ZjLP00
09/0e?oo00<0oooo00@0oooZ0;Yb0000L[X0j_ooG03oool00`3oj[X0LY_D0?ooo`020?ooo`030?oD
V`00L[X0j_oo00<0oooo00<0oooD09/0LP2jj_l0@03oool2000000d0oooo000:0?ooo`L00000Z03o
ool00`3oom@0V`1b0;[Zo`020?ooo`070>ZjLP00L[X0j_oo0?ooo`3oonX0^W8007:jjP020?ooo`03
0=BK000009/0e?oo00@0oooo00<0e9/00000V`3Dool0G@3oool01@3DV`00VmCo0?ooo`3oool0omBK
00H0000000<0001b0;[Zo`3oool0?`3oool2000000d0oooo000:0?ooo`L00000Z03oool00`3oom@0
V`1b0;[Zo`020?ooo`070?oDV`00L[X0j_oo0?ooo`3oonX0^W8009_Do`020?ooo`030=BK000009/0
e?oo00@0oooo00<0e9/0001b^P3Zool0G@3oool01`3oe9/009_D0?ooo`3oool0omBK001b^P3Zool0
0`3oool00`3oom@0V`1b0;[Zo`100?ooo`8000003@3oool000X0oooo1`00002X0?ooo`030?ooe02K
0780^^[o0080oooo00L0oooD09/0LP2jj_l0oooo0?ooe02K0780^^[o0080oooo00<0omBK0000002K
e?l00`3oool00`3oom@0V`0007:jjP1J0?ooo`0;0>[De03Zool0oooo0?ooo`3Z^W8007:j0>[oo`3o
ool0omBK001b^P3Zool00`3oool00`3oom@0V`1b0;[Zo`100?ooo`8000003@3oool000/0oooo1@00
002X0?ooo`040?oDV`000000001b0;[Zo`<0oooo00D0e9/007:jjP3oool0j[Yb002Ke0040?ooo`03
0=BK000009/0e?oo0080oooo00<0e9/00000V`3Dool0FP3oool01P3oj[X0LY_D0?ooo`3oom@0V`00
002Ke080oooo00<0omBK0000V`3Dool00`3oool00`3oom@0V`1b0;[Zo`100?ooo`8000003@3oool0
00/0oooo1@00002Y0?ooo`030?oZ^P1b0780^^[o00<0oooo00D0oooZ0;Yb0000000007:j0>[oo`05
0?ooo`060?oDV`000000000000000000L[X0j_ooG03oool01`3oe9/0000000000000L[X0j_oo0?oo
jP2jLP000`0000000`2Ke?l0oooo0>ZjLP0300000003002Ke03oool0oooo03d0oooo0P00000=0?oo
o`002`3oool500000?l0ooooK03oool2000000d0oooo000;0?ooo`D00000o`3ooom/0?ooo`800000
3@3oool000/0oooo1@00003o0?ooof`0oooo0P00000=0?ooo`002`3oool500000?l0ooooK03oool2
000000d0oooo000;0?ooo`@00000o`3ooom]0?ooo`8000003@3oool000`0oooo0`00003o0?ooofd0
oooo0P00000=0?ooo`00303oool300000?l0ooooK@3oool2000000d0oooo000<0?ooo`<00000o`3o
oom]0?ooo`8000003@3oool000`0oooo0`00003o0?ooofd0oooo0P00000=0?ooo`00303oool30000
0?l0ooooK@3oool2000000d0oooo000<0?ooo`<00000o`3ooom]0?ooo`8000003@3oool000`0oooo
0P00003o0?ooofh0oooo0P00000=0?ooo`00303oool200000?l0ooooKP3oool2000000d0oooo000<
0?ooo`800000o`3ooom^0?ooo`8000003@3oool000`0oooo0P00003o0?ooofh0oooo0P00000=0?oo
o`00303oool200000?l0ooooKP3oool2000000d0oooo000<0?ooo`800000o`3ooom^0?ooo`800000
3@3oool000`0oooo0P00003o0?ooofh0oooo0P00000=0?ooo`00303oool200000?l0ooooKP3oool3
000000`0oooo000<0?ooo`800000o`3ooom^0?ooo`<00000303oool000`0oooo0P00003o0?ooofh0
oooo0`00000<0?ooo`00303oool200000?l0ooooKP3oool3000000`0oooo000<0?ooo`800000o`3o
oom^0?ooo`<00000303oool000`0oooo0P00003o0?ooofh0oooo0`00000<0?ooo`00303oool20000
0?l0ooooK@3oool5000000/0oooo000<0?ooo`800000o`3ooom]0?ooo`D000002`3oool000`0oooo
0P00003o0?ooofd0oooo1@00000;0?ooo`00303oool200000?l0ooooK@3oool5000000/0oooo000<
0?ooo`800000o`3ooom]0?ooo`D000002`3oool000`0oooo0P00003o0?ooofd0oooo1@00000;0?oo
o`00303oool200000?l0ooooK03oool7000000X0oooo000<0?ooo`800000o`3ooom/0?ooo`L00000
2P3oool000`0oooo0P00003o0?ooof`0oooo1`00000:0?ooo`00303oool200000?l0ooooK03oool7
000000X0oooo000<0?ooo`800000o`3ooom^0?ooo`8000003@3oool000`0oooo0P00003o0?ooofh0
oooo0P00000=0?ooo`00303oool200000?l0ooooKP3oool2000000d0oooo000<0?ooo`800000o`3o
oom^0?ooo`8000003@3oool000`0oooo0P00003o0?ooofh0oooo0P00000=0?ooo`00303oool20000
0?l0ooooKP3oool2000000d0oooo000<0?ooo`800000o`3ooom^0?ooo`8000003@3oool000`0oooo
0P00003o0?ooo`l0oooo2P00001E0?ooo`8000003@3oool000`0oooo0P00003o0?ooo``0oooo4@00
001A0?ooo`8000003@3oool000`0oooo0P00003o0?ooo`X0oooo1P0000080?ooo`H00000D03oool2
000000d0oooo000<0?ooo`800000o`3oool80?ooo`D000003`3oool4000004h0oooo0P00000=0?oo
o`00303oool200000?l0oooo1`3oool400000180oooo0`00001>0?ooo`8000003@3oool000`0oooo
0P00002J0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0503oool00`000000oooo
0?ooo`0D0?ooo`030000003oool0oooo02<0oooo0`00000F0?ooo`800000C@3oool2000000d0oooo
000<0?ooo`800000VP3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01@0oooo00<0
00000?ooo`3oool04`3oool3000002<0oooo0`00000H0?ooo`800000C03oool2000000d0oooo000<
0?ooo`800000V@3oool3000001@0oooo0`00000D0?ooo`<00000503oool3000002<0oooo0P00000J
0?ooo`030000003oool0oooo04X0oooo0P00000=0?ooo`00303oool2000009T0oooo00<000000?oo
o`000000503oool00`000000oooo0000000D0?ooo`030000003oool0000001@0oooo1000000Q0?oo
o`8000006`3oool2000004/0oooo0P00000=0?ooo`00303oool2000009P0oooo0P0000000`3oool0
00000000000B0?ooo`80000000<0oooo0000000000004P3oool2000000030?ooo`00000000000180
oooo0P0000000`3oool000000000000Q0?ooo`030000003oool0oooo01/0oooo0P00001:0?ooo`80
00003@3oool000`0oooo0P00002H0?ooo`050000003oool0oooo0?ooo`0000004P3oool01@000000
oooo0?ooo`3oool000000180oooo00D000000?ooo`3oool0oooo0000000B0?ooo`030000003oool0
oooo00800000803oool2000001h0oooo0P0000190?ooo`8000003@3oool000`0oooo0P00002G0?oo
o`8000000`3oool00`000000oooo0?ooo`0?0?ooo`8000000`3oool00`000000oooo0?ooo`0?0?oo
o`8000000`3oool00`000000oooo0?ooo`0?0?ooo`8000000P3oool3000001h0oooo0P00000O0?oo
o`800000B@3oool2000000d0oooo000<0?ooo`800000U`3oool00`000000oooo0?ooo`020?ooo`80
0000403oool00`000000oooo0?ooo`020?ooo`800000403oool00`000000oooo0?ooo`020?ooo`80
0000403oool00`000000oooo0?ooo`020?ooo`8000007P3oool200000200oooo0P0000180?ooo`80
00003@3oool000`0oooo0P00002F0?ooo`8000001@3oool00`000000oooo0?ooo`0=0?ooo`800000
1@3oool00`000000oooo0?ooo`0=0?ooo`8000001@3oool00`000000oooo0?ooo`0=0?ooo`800000
103oool3000001`0oooo0P00000R0?ooo`030000003oool0oooo04H0oooo0P00000=0?ooo`00303o
ool2000009H0oooo00<000000?ooo`3oool0103oool2000000h0oooo00<000000?ooo`3oool0103o
ool2000000h0oooo00<000000?ooo`3oool0103oool2000000h0oooo00<000000?ooo`3oool0103o
ool2000001`0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0:0?ooo`800000B03o
ool2000000d0oooo000<0?ooo`800000=03oool00`000000oooo0?ooo`1N0?ooo`8000001`3oool0
0`000000oooo0?ooo`0;0?ooo`8000001`3oool00`000000oooo0?ooo`0;0?ooo`8000001`3oool0
0`000000oooo0?ooo`0;0?ooo`8000001P3oool2000001/0oooo0P00000B0?ooo`H000002P3oool2
000004P0oooo0P00000=0?ooo`00303oool2000003@0oooo2`00001F0?ooo`030000003oool0oooo
00H0oooo0P00000<0?ooo`030000003oool0oooo00H0oooo0P00000<0?ooo`030000003oool0oooo
00H0oooo0P00000<0?ooo`030000003oool0oooo00D0oooo0`00000J0?ooo`8000004P3oool70000
00T0oooo0P0000180?ooo`8000003@3oool000`0oooo0P00000d0?oooa@00000@@3oool00`000000
oooo0?ooo`080?ooo`8000002@3oool00`000000oooo0?ooo`090?ooo`8000002@3oool00`000000
oooo0?ooo`090?ooo`8000002@3oool00`000000oooo0?ooo`090?ooo`800000203oool2000001X0
oooo0P00000:0?ooo`030000003oool0oooo00@0oooo0P0000040?ooo`<00000203oool3000004L0
oooo0P00000=0?ooo`00303ooon=000000T0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01`3ooolN000000T0oooo
0`0000040?ooo`<000001@3oool3000000P0ooooB`00000=0?ooo`00303ooon=000000T0oooo00<0
00000?ooo`3oool0203oool2000000X0oooo00<000000?ooo`3oool0203oool2000000X0oooo00<0
00000?ooo`3oool0203oool2000000X0oooo00<000000?ooo`3oool01`3ooolN000000X0oooo0P00
00040?ooo`8000001`3oool00`000000oooo0?ooo`070?oood/000003@3oool00480oooo3P000017
0?ooo`800000203oool2000000/0oooo00<000000?ooo`3oool01`3oool2000000/0oooo00<00000
0?ooo`3oool01`3oool2000000/0oooo00<000000?ooo`3oool01`3oool2000002D0oooo0P00000:
0?ooo`800000103oool200000140oooo00<000000?ooo`3oool0E@3oool00480oooo2000001=0?oo
o`<000001`3oool00`000000oooo0?ooo`0:0?ooo`800000203oool00`000000oooo0?ooo`0:0?oo
o`800000203oool00`000000oooo0?ooo`0:0?ooo`800000203oool00`000000oooo0?ooo`0T0?oo
o`8000002P3oool800000100oooo0P00001G0?ooo`00@P3oool2000005@0oooo0P0000060?ooo`80
00003@3oool00`000000oooo0?ooo`050?ooo`8000003@3oool00`000000oooo0?ooo`050?ooo`80
00003@3oool00`000000oooo0?ooo`050?ooo`8000009P3oool2000000/0oooo1P00000A0?ooo`80
0000E`3oool009P0oooo0`0000050?ooo`030000003oool0oooo00`0oooo0P0000060?ooo`030000
003oool0oooo00`0oooo0P0000060?ooo`030000003oool0oooo00`0oooo0P0000060?ooo`030000
003oool0oooo02H0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0A0?ooo`800000
E`3oool009T0oooo0P0000040?ooo`8000003`3oool00`000000oooo0?ooo`030?ooo`8000003`3o
ool00`000000oooo0?ooo`030?ooo`8000003`3oool00`000000oooo0?ooo`030?ooo`800000:03o
ool200000240oooo0P00001G0?ooo`00V@3oool2000000@0oooo00<000000?ooo`3oool03P3oool2
000000@0oooo00<000000?ooo`3oool03P3oool2000000@0oooo00<000000?ooo`3oool03P3oool2
000000@0oooo00<000000?ooo`3oool0:03oool200000200oooo0P00001G0?ooo`00V@3oool30000
0080oooo0P00000A0?ooo`040000003oool0oooo0?ooo`8000004@3oool010000000oooo0?ooo`3o
ool200000140oooo00@000000?ooo`3oool0oooo0P00000Z0?ooo`8000007`3oool2000005P0oooo
002J0?ooo`8000000P3oool00`000000oooo0?ooo`0@0?ooo`050000003oool0oooo0?ooo`000000
4P3oool01@000000oooo0?ooo`3oool000000180oooo00D000000?ooo`3oool0oooo0000000/0?oo
o`8000007P3oool2000005P0oooo002J0?ooo`D000004P3oool2000000030?ooo`00000000000180
oooo0P0000000`3oool000000000000B0?ooo`80000000<0oooo000000000000;@3oool00`000000
oooo0?ooo`0K0?ooo`800000F@3oool009/0oooo0`00000D0?ooo`030000003oool0000001@0oooo
00<000000?ooo`000000503oool00`000000oooo0000000^0?ooo`800000703oool00`000000oooo
0?ooo`1H0?ooo`00V`3oool3000001@0oooo0`00000D0?ooo`<00000503oool3000002l0oooo0P00
000J0?ooo`800000FP3oool009/0oooo0`00000E0?ooo`030000003oool0oooo01@0oooo00<00000
0?ooo`3oool0503oool00`000000oooo0?ooo`0_0?ooo`800000603oool2000005/0oooo002L0?oo
o`030000003oool0oooo01@0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0D0?oo
o`030000003oool0oooo02l0oooo0`00000E0?ooo`<00000G03oool00?l0oooo5@3oool400000180
oooo1000001L0?ooo`00o`3ooolF0?ooo`D000003`3oool3000005h0oooo003o0?oooaP0oooo1000
000<0?ooo`@00000G`3oool00?l0oooo6P3oool6000000@0oooo1`00001P0?ooo`00o`3ooolK0?oo
o`h00000HP3oool00?l0oooo7`3oool6000006H0oooo003o0?oooh/0oooo003o0?oooh/0oooo002g
0?ooo`050?oDV`00000000000000002Ke?l00`3oool01@3oonX0^W8000000000L[X0j_oo0080oooo
00P0j[Yb000000000000000007:jjP3oool0onZj07800080000000<0L[[Z0?ooo`3oool0D03oool0
1@3oj[X0LP00000000000000VmCo0080oooo00D0onZj078000000000000009_Do`020?ooo`050?oo
jP2jLP000000001b^P3Zool01`3oool00`3oonX0^W:K0=Coo`1:0?ooo`00^P3oool00`3oonX0^W80
09_Do`020?ooo`050=BK001b^^X0oooo0>ZjLP00Vm@00P3oool01@3DVi/0e?oo0?oojP2jVkX0j_oo
0080oooo00@0j[ZK0;[Zo`3oom@0Vi_DD`3oool00`3oom@0V`1b0;[Zo`040?ooo`030?ooe02K0780
^^[o00<0oooo00D0e9/007:jjP3oool0j[Yb002Ke0070?ooo`030?oZ^P1b0000L[[Z04X0oooo002k
0?ooo`0:0?oDV`00Vm@0oooo0?oZ^P1b09/0e?oo0?ooo`3oom@0V`1b0;[Zo`<0oooo00<0e9/007:j
jP3oool00P3oool00`3oj[X0LW:j0>[oo`1D0?ooo`030?ooe02K0780^^[o00@0oooo00<0oooD09/0
LP2jj_l00P3oool01`3oj[X0LP2K0=Coo`3oool0oooD09/0LP2jj_l01P3oool0103DV`0007:K09^K
^P3Zoom90?ooo`00^`3oool02P3Z^W8007:j0>[oo`3oe9/007:j0>[oo`3oool0oooZ0;Yb002Ke?l2
0?ooo`030?oZ^P1b0780^^[o00<0oooo00<0oooD09/0001b^^X0E03oool00`3oom@0V`1b0;[Zo`04
0?ooo`030?ooe02K0780^^[o0080oooo00L0omBK001b^P3Zool0oooo0?oojP2jLP00VmCo00D0oooo
00D0onZj0780002Ke?l0omBK09_Do`190?ooo`00^P3oool02`3oj[X0LP0007:jjP3oool0j[Yb001b
^P3Zool0oooo0?oojP2jLP00L[[Z0080oooo00<0j[Yb0000V`3Dool00`3oool0103oonX0^W80001b
^P3ZoomC0?ooo`030?ooe02K0780^^[o00@0oooo00<0oooD09/0LP2jj_l00P3oool01`3Z^W8007:j
0>[oo`3oool0oooZ0;Yb001b^^X01@3oool01P3DV`0007:j0>[oo`3oonX0^Y^j0>[oodP0oooo002i
0?ooo`030=BK0000000009_D0080oooo00L0j[Yb001b^P3Zool0oooo0?oojP2jLP00L[[Z0080oooo
00<0e9/00000V`3Dool0103oool00`3DV`00002K0=Coo`1C0?ooo`030?ooe02K0780^^[o00@0oooo
00<0oooD09/0LP2jj_l00P3oool01`3Z^W8007:j0>[oo`3oool0oooZ0;Yb001b^^X0103oool00`3o
j[X0LP0009_Do`020?ooo`030?oDV`2Ke?l0oooo04L0oooo002j0?ooo`0;0?oDV`00Vm@0oooo0?oo
o`3oe9/007:j0>[oo`3oool0oooZ0;Yb002Ke?l00P3oool00`3DV`00002K0=Coo`040?ooo`030=BK
0000L[X0j_oo05<0oooo00<0oooD09/0LP2jj_l0103oool00`3oom@0V`1b0;[Zo`020?ooo`070?oD
V`00L[X0j_oo0?ooo`3oonX0^W8009_Do`040?ooo`030=BK0000L[X0j_oo0080oooo00<0oooD09^K
e03oool0A`3oool00;L0oooo00h0on[Z0>[oo`3oool0oooo0=BK002Ke?l0oooo0?ooe02K0780^^[o
0?ooo`3oom@0V`1b0;[Zo`80oooo00<0omBK0000002Ke?l00`3oool00`3oom@0V`0007:jjP1D0?oo
o`030?ooe02K0780^^[o00@0oooo00<0oooD09/0LP2jj_l00P3oool01`3oom@0V`1b0;[Zo`3oool0
oooD09/0LP2jj_l00`3oool00`3oj[X0LP0009_Do`040?ooo`030>ZjV`2jj_l0oooo04H0oooo002g
0?ooo`060?ooe02KL[X0j_oo0?ooe02K0000VmCo0P3oool01@3DV`00L[[Z0?ooo`3Z^W8009_D00@0
oooo00<0e9/00000V`3Dool00P3oool00`3DV`00002K0=Coo`1C0?ooo`040?oDV`000000001b0;[Z
o`<0oooo00@0omBK000000000780^^[o0`3oool01@3DV`00L[[Z0?ooo`3Z^W8009_D00@0oooo00<0
e9/00000LP2jj_l0103oool00`3oe9/007:j0>[oo`160?ooo`00^03oool0103oj[X0LP0000000000
Vm@30?ooo`050?oojP2jLP000000001b^P3Zool01@3oool01P3oe9/0000000000000000007:j0>[o
oeD0oooo00<0onZj0780LP2jj_l0103oool00`3oj[X0LP1b0;[Zo`030?ooo`050?oojP2jLP000000
001b^P3Zool00P3oool01P3oonX0^W80000000000000001b0;[Zo`80oooo00D0omBK000000000000
07:j0>[oo`150?ooo`00o`3ooon;0?ooo`00o`3ooon;0?ooo`00o`3ooon;0?ooo`00o`3ooon;0?oo
o`00o`3ooon;0?ooo`00o`3ooon;0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 393.938}, {239.625, 0}} -> {-0.0739166, -0.599225, \
0.00817834, 0.00817834}}],

Cell[TextData[{
  "\nSugerencias. En alg\[UAcute]n caso tendr\[AAcute]s que ayudar a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " usando alguna propiedad de la transformada de Laplace de forma apropiada. \
En c) debes tener en cuenta que una transformada de Laplace de una funci\
\[OAcute]n debe tener l\[IAcute]mite 0 en ",
  Cell[BoxData[
      \(TraditionalForm\`\(+\[Infinity]\)\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 8", "Exercise"],

Cell[TextData[{
  "Considera las siguientes matrices:\n",
  Cell[BoxData[
      \(TraditionalForm\`A = {{4, 2\/3, 4\/3, 8}, {0, \(-2\), 1, 0}, {0, 0, 
            1, 0}, {\(-\(1\/4\)\), \(-\(31\/66\)\), \(-\(1\/11\)\), 1}}\)]],
  ",\n",
  Cell[BoxData[
      \(TraditionalForm\`B = {{8, 4\/3, 8\/3, 16}, {0, 4, 1\/4, 
            0}, {0, \(-4\), 2, 
            0}, {\(-\(1\/2\)\), \(-\(31\/33\)\), \(-\(2\/11\)\), 2}}\)]],
  ",\n",
  Cell[BoxData[
      \(TraditionalForm\`W = {{1, \(-\(1300\/33\)\), \(-\(85\/11\)\), 0}, {0, 
            6, 3\/4, 0}, {0, \(-12\), 12, 0}, {0, 147\/11, 105\/44, 1}}\)]],
  ".\na) Calcula la exponencial de dichas matrices de dos formas:\na1) Usando \
el m\[EAcute]todo del polinomio interpolador.\na2) Con el comando MatrixExp[ \
].\na3) Calcula ",
  Cell[BoxData[
      \(TraditionalForm\`seno[A\ t] . seno[A\ t] + 
        coseno[A\ t] . coseno[A\ t]\)]],
  "\nComprueba que los resultados coinciden.\nb) La funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(z) = \(Cos[z] - 1\)\/z\^2, \ f(0) = \(-1\)/2\)]],
  " es una funci\[OAcute]n anal\[IAcute]tica en todo el plano complejo. \
Calcula ",
  Cell[BoxData[
      \(TraditionalForm\`f(B)\)]],
  " de tres formas:\nb1) Usando el m\[EAcute]todo del polinomio interpolador.\
\nb2) Con el comando MatrixExp[ ].\nb3) Usando transformadas de Laplace.\n\
Comprueba que los resultados coinciden."
}], "ExerciseText"]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 68, 3, 174, "Title"],

Cell[CellGroupData[{
Cell[1847, 58, 73, 0, 68, "Exercise"],
Cell[1923, 60, 2906, 83, 469, "ExerciseText"],
Cell[4832, 145, 444, 12, 67, "ExerciseText"],
Cell[5279, 159, 1893, 61, 205, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7209, 225, 75, 0, 68, "Exercise"],
Cell[7287, 227, 4039, 115, 505, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11363, 347, 116, 3, 68, "Exercise"],
Cell[11482, 352, 2577, 73, 336, "ExerciseText"],
Cell[14062, 427, 819, 19, 119, "ExerciseText"],
Cell[14884, 448, 655, 12, 176, "Input"],
Cell[15542, 462, 2633, 59, 461, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18212, 526, 68, 0, 67, "Subsubsection"],
Cell[18283, 528, 730, 17, 93, "ExerciseText"],
Cell[19016, 547, 298, 5, 38, "ExerciseText"],
Cell[19317, 554, 228, 4, 38, "ExerciseText"],
Cell[19548, 560, 1413, 33, 171, "ExerciseText"],
Cell[20964, 595, 215, 3, 98, "Input"],
Cell[21182, 600, 102, 2, 41, "ExerciseText"],
Cell[21287, 604, 112, 2, 72, "Input"],
Cell[21402, 608, 615, 18, 93, "ExerciseText"],
Cell[22020, 628, 50, 1, 72, "Input"],
Cell[22073, 631, 136, 3, 41, "ExerciseText"],
Cell[22212, 636, 231, 4, 150, "Input"],
Cell[22446, 642, 296, 5, 67, "ExerciseText"],
Cell[22745, 649, 298, 5, 38, "ExerciseText"],
Cell[23046, 656, 161, 5, 41, "ExerciseText"],
Cell[23210, 663, 180, 3, 35, "ExerciseText"],
Cell[23393, 668, 304, 9, 67, "ExerciseText"],
Cell[23700, 679, 185, 3, 98, "Input"],
Cell[23888, 684, 1070, 22, 171, "ExerciseText"],
Cell[24961, 708, 185, 3, 98, "Input"],
Cell[25149, 713, 303, 10, 41, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25489, 728, 44, 0, 68, "Exercise"],
Cell[25536, 730, 1816, 27, 421, "ExerciseText"],
Cell[27355, 759, 6115, 151, 1025, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[33507, 915, 79, 0, 68, "Exercise"],
Cell[33589, 917, 1198, 28, 171, "ExerciseText"],
Cell[34790, 947, 24183, 583, 168, 8527, 386, "GraphicsData", "PostScript", \
"Graphics"],
Cell[58976, 1532, 4475, 133, 301, "ExerciseText"],
Cell[63454, 1667, 774, 13, 254, "Input"],
Cell[64231, 1682, 1203, 36, 98, "ExerciseText"],
Cell[65437, 1720, 139, 2, 91, "Input"],
Cell[65579, 1724, 5025, 145, 656, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[70641, 1874, 42, 0, 68, "Exercise"],
Cell[70686, 1876, 212, 6, 41, "ExerciseText"],
Cell[70901, 1884, 252, 5, 36, "Text"],
Cell[71156, 1891, 317, 9, 42, "ExerciseText"],
Cell[71476, 1902, 409, 7, 61, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[71922, 1914, 31, 0, 68, "Exercise"],
Cell[71956, 1916, 1516, 37, 376, "ExerciseText"],
Cell[73475, 1955, 59895, 1876, 253, 27110, 1468, "GraphicsData", \
"PostScript", "Graphics"],
Cell[133373, 3833, 427, 10, 127, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[133837, 3848, 31, 0, 68, "Exercise"],
Cell[133871, 3850, 1407, 30, 526, "ExerciseText"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

